import { setupShallowTest } from '../tests/enzyme-util/shallow';
import { ExternalView } from './component';
import { timeout } from '../tests/utils';
import { ExtensionAnchor, ExtensionMode, ExtensionPlatform } from 'extension-coordinator';
import { createViewsForTest, createExtensionManifestForTest } from '../tests/constants/extension';
import { ViewerType, ExtensionType } from '../core/models/rig';

let extensionAnchor: ExtensionType;
function mockApiFunctions() {
  return {
    ...require.requireActual('../util/api'),
    fetchProject: jest.fn(() => ({
      project: { manifest: createExtensionManifestForTest() },
      secret: 'secret',
      view: createViewsForTest(1, extensionAnchor, ViewerType.Broadcaster)[0],
    })),
  };
}
jest.mock('../util/api', () => mockApiFunctions());
const api = require.requireMock('../util/api');

describe('<ExternalView />', () => {
  const setupShallow = setupShallowTest(ExternalView, () => ({
    referenceId: 'referenceId',
  }));

  it('renders as component', async () => {
    extensionAnchor = ExtensionAnchor.Component;
    setupShallow();
    await timeout();
    expect(api.fetchProject).toHaveBeenCalled();
  });

  it('renders as config', async () => {
    extensionAnchor = ExtensionMode.Config;
    setupShallow();
    await timeout();
    expect(api.fetchProject).toHaveBeenCalled();
  });

  it('renders as dashboard', async () => {
    extensionAnchor = ExtensionMode.Dashboard;
    setupShallow();
    await timeout();
    expect(api.fetchProject).toHaveBeenCalled();
  });

  it('renders as mobile', async () => {
    extensionAnchor = ExtensionPlatform.Mobile;
    setupShallow();
    await timeout();
    expect(api.fetchProject).toHaveBeenCalled();
  });

  it('renders as overlay', async () => {
    extensionAnchor = ExtensionAnchor.Overlay;
    setupShallow();
    await timeout();
    expect(api.fetchProject).toHaveBeenCalled();
  });

  it('renders as panel', async () => {
    extensionAnchor = ExtensionAnchor.Panel;
    setupShallow();
    await timeout();
    expect(api.fetchProject).toHaveBeenCalled();
  });
});
