import * as React from 'react';
import './component.sass';
import { RigExtensionView } from '../core/models/rig';
import { ExtensionObject } from 'extension-coordinator';
import { createExtensionObject } from '../util/extension';
import { fetchProject } from '../util/api';
import { ExtensionViewSelector } from '../extension-view-selector';

interface Props {
  referenceId: string;
}

interface State {
  extension: ExtensionObject;
  view: RigExtensionView;
}

export class ExternalView extends React.Component<Props, State> {
  public async componentDidMount() {
    const { project, secret, view } = await fetchProject(this.props.referenceId);
    const linkedUserId = view.linked ? view.linkedUserId : '';
    const extension = createExtensionObject(project.manifest, '0', view.viewerType,
      linkedUserId, view.channelId, secret, view.opaqueId);
    this.setState({ extension, view });
  }

  public render() {
    if (!this.state || !this.state.view) {
      return null;
    }
    const { extension, view } = this.state;
    return (
      <div className="external-view">
        <ExtensionViewSelector extension={extension} hasBorder={false} isExtensionVisible={true} isNonoVisible={false} view={view} onDeleteView={() => { }} />
      </div>
    );
  }
}
