import React from 'react';
import ReactDOM from 'react-dom';
import 'twitch-core-ui/css/index.css';
import { ExternalView } from './external-view';
import { ProcessView } from './process-view';
import { Rig } from './rig';
import { sendEvent, openUrl } from './util/api';

/* eslint no-restricted-globals: "off" */
const url = new URL(location.href);
/* eslint no-restricted-globals: "error" */
const root = document.getElementById('root')!;
const secondary = document.getElementById('secondary')!;
const ref = url.searchParams.get('ref');
if (ref) {
  root.remove();
  ReactDOM.render(<ExternalView referenceId={ref} />, secondary);
} else if (url.searchParams.get('view') === 'secondary') {
  root.remove();
  ReactDOM.render(<ProcessView />, secondary);
} else {
  secondary.remove();
  document.body.onclick = (event) => {
    for (let element = event.srcElement as Element | null; element; element = element.parentElement) {
      if (['A', 'BUTTON'].some((tagName) => element!.tagName === tagName)) {
        (element as HTMLAnchorElement | HTMLButtonElement).blur();
        const eventName = element.tagName === 'A' ? 'dx_rig_link_click' : 'dx_rig_button_click';
        const name = element.getAttribute('aria-label');
        if (name) {
          const eventData: { [key: string]: any } = {};
          if (element.tagName === 'A') {
            const url = (element as HTMLAnchorElement).href;
            eventData.link_name = name;
            eventData.link_url = url;
            if (url && !url.endsWith('/#')) {
              openUrl(url);
              event.preventDefault();
            }
          } else {
            eventData.button_name = name;
          }
          if (name.split(':')[0] !== 'RigNav' || eventData.link_url) {
            sendEvent(eventName, eventData);
          }
        }
        break;
      }
    }
  };
  ReactDOM.render(<Rig />, root);
}
