import { setupShallowTest } from '../tests/enzyme-util/shallow';
import { LoadFailureView } from './component';
import { timeout } from '../tests/utils';

function mockApiFunctions() {
  const original = require.requireActual('../util/api');
  return {
    ...original,
    showOpenDialog: jest.fn(() => Promise.resolve('filePath')),
  }
}
jest.mock('../util/api', () => mockApiFunctions());
const api = require.requireMock('../util/api');

describe('<LoadFailureView />', () => {
  const setupShallow = setupShallowTest(LoadFailureView, () => ({
    projectFilePath: 'projectFilePath',
    projectName: 'projectName',
    onChangePath: jest.fn(),
    onRemove: jest.fn()
  }));

  it('renders correctly', () => {
    const { wrapper } = setupShallow();
    expect(wrapper.debug()).toMatchSnapshot();
  });

  it('invokes onChangePath upon clicking "Locate" and entering a file path', async () => {
    const { props, wrapper } = setupShallow();
    const expectedValue = 'filePath';
    wrapper.find('Button').first().simulate('click');
    await timeout();
    expect(api.showOpenDialog).toHaveBeenCalled();
    expect(props.onChangePath).toHaveBeenCalledWith(expectedValue);
  });

  it('invokes onRemove upon clicking "Remove"', () => {
    const { props, wrapper } = setupShallow();
    wrapper.find('Button').last().simulate('click');
    expect(props.onRemove).toHaveBeenCalled();
  });
});
