import * as React from 'react';
import './component.sass';
import { showOpenDialog } from '../util/api';
import { Button, ButtonType, CoreText, TextType, FontSize } from 'twitch-core-ui';

interface Props {
  projectFilePath: string;
  projectName: string;
  onChangePath: (filePath: string) => void;
  onRemove: () => void;
}

export class LoadFailureView extends React.Component<Props>{
  private locate = async () => {
    const filePath = await showOpenDialog({
      filters: [
        { name: 'JSON files', extensions: ['json'] },
        { name: 'All Files', extensions: ['*'] },
      ],
      properties: ['openFile'],
    });
    if (filePath) {
      this.props.onChangePath(filePath);
    }
  }

  public render() {
    return (
      <div className="load-failure-view">
        <CoreText fontSize={FontSize.Size4}>Cannot find project <CoreText
          type={TextType.Strong}>{this.props.projectName}</CoreText> at <CoreText
            type={TextType.Strong}>{this.props.projectFilePath}</CoreText>.</CoreText>
        <div className="load-failure-view__buttons">
          <Button ariaLabel="LoadFailureView:Locate" type={ButtonType.Hollow} onClick={this.locate}>Locate</Button>
          <Button ariaLabel="LoadFailureView:Remove" type={ButtonType.Hollow} onClick={this.props.onRemove}>Remove</Button>
        </div>
      </div>
    );
  }
}
