import { setupShallowTest } from '../tests/enzyme-util/shallow';
import { ProjectNav } from './component';
import { LocalStorage } from '../util/local-storage';
import { UserSession } from '../core/models/user-session';

describe('<ProjectNav />', () => {
  const defaultGenerator = () => ({
    currentProjectIndex: 0,
    projectReferences: [{
      filePath: 'filePath',
      name: 'name',
      secret: '',
    }],
    createProject: jest.fn(),
    logout: jest.fn(),
    selectProject: jest.fn(),
  });
  const setupRenderer = setupShallowTest(ProjectNav, defaultGenerator);
  const localStorage = new LocalStorage();

  it('renders correctly with session', () => {
    const userSession: UserSession = {
      authToken: 'authToken',
      displayName: 'displayName',
      email: 'email@email.com',
      expiration: Date.parse('3333-03-03'),
      id: 'id',
      login: 'login',
      profileImageUrl: 'profileImageUrl',
    };
    localStorage.rigLogin = userSession;
    const { wrapper } = setupRenderer();
    expect(wrapper.debug()).toMatchSnapshot();
  });

  it('does not render without session', () => {
    localStorage.rigLogin = undefined;
    const { wrapper } = setupRenderer();
    expect(wrapper.debug()).toMatchSnapshot();
  });
});
