import * as React from 'react';
import './component.sass';
import classNames from 'classnames';
import { RigProjectReference } from '../core/models/rig';
import { UserDropdown } from '../user-dropdown';
import { LocalStorage } from '../util/local-storage';
import { Background, Color, CoreLink, CoreLinkType, CoreText, Display, FontSize, Layout, StyledLayout } from 'twitch-core-ui';

export interface Props {
  currentProjectIndex: number;
  projectReferences: RigProjectReference[];
  logout: () => void;
  selectProject: (projectIndex: number) => void;
}

export class ProjectNav extends React.Component<Props>{
  public render() {
    const { currentProjectIndex, projectReferences, logout, selectProject } = this.props;
    const localStorage = new LocalStorage();
    const session = localStorage.rigLogin;
    return (
      <StyledLayout background={Background.AccentAlt2} color={Color.Inherit} display={Display.Flex}>
        {projectReferences.map(({ filePath, name }, index) => {
          const className = classNames('project-nav__link', {
            'project-nav__link--active': index === currentProjectIndex,
          });
          return <CoreLink key={filePath}
            ariaLabel={`ProjectNav:${name}`} className={className}
            hoverColorInherit hoverUnderlineNone type={CoreLinkType.Inherit}
            onClick={() => selectProject(index)}>
            <CoreText fontSize={FontSize.Size4} ellipsis>{name}</CoreText>
          </CoreLink>;
        })}
        {session && <Layout margin={{ left: 'auto' }}>
          <UserDropdown session={session} logout={logout} />
        </Layout>}
      </StyledLayout>
    );
  }
}
