import * as React from 'react';
import './component.sass';
import { Dialog } from '../dialog';
import { Color, CoreText, FontSize, CoreLink } from 'twitch-core-ui';

interface Props {
  onClose: () => void;
}

export function ReleaseNotesDialog(props: Props) {
  const rfc0012Url = 'https://discuss.dev.twitch.tv/t/rfc-0012-component-extension-redesign/21072';
  return (
    <Dialog className="release-notes-dialog" canConfirm confirmText="OK" title="Release Notes" confirmHandler={props.onClose}>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 1.2.14</CoreText>
        <CoreText bold color={Color.Base}>Upgrade TypeScript, Electron, and Electron Builder</CoreText>
        <CoreText className="release-notes-dialog__details">TypeScript is now at version 4.1.3.  Electron is now at version 11.1.1.
          Electron Builder is now at version 22.9.1.</CoreText>
        <CoreText bold color={Color.Base}>Simplify front-end hosting text</CoreText>
        <CoreText className="release-notes-dialog__details">Whether or not the Developer Rig uses a random port depends on whether
          or not the user checks the check box.</CoreText>
        <CoreText bold color={Color.Base}>Show button instead of context menu when collapsed</CoreText>
        <CoreText className="release-notes-dialog__details">This button expands the view so the context menu is visible again.</CoreText>
        <CoreText bold color={Color.Base}>Display a message in case of invalid views</CoreText>
        <CoreText className="release-notes-dialog__details">If the user changes the Extension manifest on the Console to exclude a
          particular view, display a message for views that are no longer valid along with a button to delete them.</CoreText>
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 1.2.13</CoreText>
        <CoreText bold color={Color.Base}>Provide option to host on specified port</CoreText>
        <CoreText className="release-notes-dialog__details">It is now possible to have the Developer Rig host your front end on the
          port you specify in Testing Base URI.  This is the default for new projects.  The Developer Rig will still use a random
          port to host current projects unless you clear the check box in Project Details.</CoreText>
        <CoreText className="release-notes-dialog__details">The Developer Rig will ignore all other components of that URL.  If you
          do not explicitly specify a port, the Developer Rig will not attempt to use the default port, 80, since that port is
          normally unavailable to non-administrative users.  If you want the Developer Rig to use port 80, specify it explicitly in
          Testing Base URI.</CoreText>
        <CoreText bold color={Color.Base}>Move the "Edit Context" drop-down to the left</CoreText>
        <CoreText className="release-notes-dialog__details">This prevents the right side of the sub-menu from being clipped.</CoreText>
        <CoreText bold color={Color.Base}>Hijack the settings button for extension refresh</CoreText>
        <CoreText className="release-notes-dialog__details">For video component extensions especially, refreshing only the
          extension instead of the entire view is a more pleasant experience.</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 1.2.12</CoreText>
        <CoreText bold color={Color.Base}>Check the return value of showOpenDialog</CoreText>
        <CoreText className="release-notes-dialog__details">On Windows, it returns an object containing a filePaths array field.
          On macOS, it returns an array. The latter behavior is undocumented.  This addresses <a
            aria-label="ReleaseNotesDialog:GitHub issue #205" href="https://github.com/twitchdev/issues/issues/205">GitHub
          issue #205</a>.</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 1.2.11</CoreText>
        <CoreText bold color={Color.Base}>Refresh secret when refreshing manifest</CoreText>
        <CoreText className="release-notes-dialog__details">Developers have experienced problems when they change their secrets.
          They tried refreshing their manifests so that's a good place to update the secret.</CoreText>
        <CoreText bold color={Color.Base}>Change check boxes to radio buttons</CoreText>
        <CoreText className="release-notes-dialog__details">It takes up slightly more vertical space but provides a clearer
          experience.</CoreText>
        <CoreText bold color={Color.Base}>Ignore metrics failures</CoreText>
        <CoreText className="release-notes-dialog__details">This addresses <a
          aria-label="ReleaseNotesDialog:GitHub issue #182" href="https://github.com/twitchdev/issues/issues/182">GitHub
          issue #182</a>.</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 1.2.10</CoreText>
        <CoreText bold color={Color.Base}>Provide a softer background for the "Loading" screen</CoreText>
        <CoreText className="release-notes-dialog__details">It uses the same background as other views so transitions are
          smoother.</CoreText>
        <CoreText bold color={Color.Base}>Improve Configuration Service View text</CoreText>
        <CoreText bold color={Color.Base}>Upgrade Electron to version 9</CoreText>
        <CoreText className="release-notes-dialog__details">This provides a more up-to-date version of Chromium (83.0.4103.122)
          which enables contemporary JavaScript (e.g. Array.flatMap).  This addresses <a
          aria-label="ReleaseNotesDialog:GitHub issue #54" href="https://github.com/twitchdev/issues/issues/54">GitHub
          issue #54</a>.</CoreText>
        <CoreText bold color={Color.Base}>Provide a dismissible notification about refreshing</CoreText>
        <CoreText bold color={Color.Base}>Replace drop-down menu with buttons</CoreText>
        <CoreText className="release-notes-dialog__details">Having the "Refresh Manifest" button in a drop-down menu worsens its
          discovery.</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 1.2.9</CoreText>
        <CoreText bold color={Color.Base}>Ensure views render panels with height in manifest</CoreText>
        <CoreText className="release-notes-dialog__details">This addresses <a
          aria-label="ReleaseNotesDialog:GitHub issue #162" href="https://github.com/twitchdev/issues/issues/162">GitHub
          issue #162</a>.</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 1.2.8</CoreText>
        <CoreText bold color={Color.Base}>Enable hiding "no-no" zones</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 1.2.7</CoreText>
        <CoreText bold color={Color.Base}>Move Twitch embedded player into a webview</CoreText>
        <CoreText className="release-notes-dialog__details">All ancestors must adhere to its CSP settings.</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 1.2.6</CoreText>
        <CoreText bold color={Color.Base}>Report duplicate name in case of creation error</CoreText>
        <CoreText bold color={Color.Base}>Add Client-Id header to New Twitch API invocations</CoreText>
        <CoreText className="release-notes-dialog__details">The New Twitch API now requires OAuth tokens and a matching Client-Id
          header for all endpoints.</CoreText>
        <CoreText bold color={Color.Base}>Update Twitch embedded player</CoreText>
        <CoreText className="release-notes-dialog__details"> The Twitch embedded player source URL requirements changed.  See <a
          aria-label="ReleaseNotesDialog:Embedding Video and Clips" href="https://dev.twitch.tv/docs/embed/video-and-clips/">Embedding
          Video and Clips</a> for more information.</CoreText>
        <CoreText bold color={Color.Base}>Correct the 480p size</CoreText>
        <CoreText className="release-notes-dialog__details">The width of such a video is 852.</CoreText>
        <CoreText bold color={Color.Base}>Track custom sizes separately</CoreText>
        <CoreText bold color={Color.Base}>Ensure context menu buttons have same width</CoreText>
        <CoreText bold color={Color.Base}>Remove unused configuration fields</CoreText>
        <CoreText bold color={Color.Base}>Provide additional context upon API failure</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 1.2.5</CoreText>
        <CoreText bold color={Color.Base}>Implement view collapsing</CoreText>
        <CoreText className="release-notes-dialog__details">The view description in each view header is now a button that toggles
          the visibility of its view.</CoreText>
        <CoreText bold color={Color.Base}>Correct certificate exception origin check</CoreText>
        <CoreText className="release-notes-dialog__details">The results of "new URL" and "url.parse" have some dissimilar
          properties.</CoreText>
        <CoreText bold color={Color.Base}>Disable front-end hosting if unspecified</CoreText>
        <CoreText className="release-notes-dialog__details">This commit also clarifies the descriptions of the front- and back-end
          hosting options.</CoreText>
        <CoreText bold color={Color.Base}>Use relative front-end path if no dots</CoreText>
        <CoreText className="release-notes-dialog__details">If the path to the front-end files is for a directory that is a
          descendant of the project directory, specify it as a relative path.</CoreText>
        <CoreText bold color={Color.Base}>Validate the NVM installation</CoreText>
        <CoreText className="release-notes-dialog__details">It's possible NVM is installed but there is no $NVM_DIR/versions/node
          directory, perhaps because NVM has not yet been used to install any version of Node.</CoreText>
        <CoreText bold color={Color.Base}>Add "Refresh All Views" button</CoreText>
        <CoreText bold color={Color.Base}>Require explicit action to allow certificate</CoreText>
        <CoreText className="release-notes-dialog__details">The "Allow" option was a check box so it was possible to miss it. Now,
          as a radio button, selecting either "Yes" or "No" is required to dismiss the dialog.</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 1.2.4</CoreText>
        <CoreText bold color={Color.Base}>Hide menu upon opening Edit Orientation dialog</CoreText>
        <CoreText bold color={Color.Base}>Enable interaction with the player controls</CoreText>
        <CoreText className="release-notes-dialog__details">For video overlays, there is an option in the "dots" menu to hide the
          extension.  Since the Developer Rig includes the player as an external component, it isn't feasible for it to inject the
          extension above the video and below the controls.</CoreText>
        <CoreText className="release-notes-dialog__details">For video components, the player controls are available.</CoreText>
        <CoreText bold color={Color.Base}>Check for Node if necessary</CoreText>
        <CoreText className="release-notes-dialog__details">Selecting either "Use Extension tutorial example" or "Use boilerplate
          code" when creating a project requires NPM.  Since it's included with Node, ensure there is a Node installation in either
          of those two cases.  Display a dialog to suggest remediation options if it is not found.</CoreText>
        <CoreText bold color={Color.Base}>Check for Node Version Manager</CoreText>
        <CoreText className="release-notes-dialog__details">Since NVM installs Node into its own directory, check for the .nvm
          directory.  If found, check for a "current" symbolic link in the .nvm directory, then check for a .nvmrc file in the
          $HOME directory, then check for the NVM default in the .nvm/alias directory.</CoreText>
        <CoreText bold color={Color.Base}>Protect against legacy views</CoreText>
        <CoreText className="release-notes-dialog__details">This protection extends to invalid viewer URLs due to invalid paths
          specified in the "Asset Hosting" section.</CoreText>
        <CoreText bold color={Color.Base}>Distinguish between the different types of secrets</CoreText>
        <CoreText className="release-notes-dialog__details">The Developer Rig now accepts only Extension secrets, rejecting API
          client secrets.</CoreText>
        <CoreText bold color={Color.Base}>Separate application URLs from Extension URLs</CoreText>
        <CoreText className="release-notes-dialog__details">The application now opens its own URLs by explicitly invoking a handler
          in the main process.  Extensions open their URLs via the "new-window" event handler where the application verifies they
          are allowed.  This ensures extensions may open only those URLs found in the "Whitelist config Urls" and "Whitelist panel
          Urls" lists.</CoreText>
        <CoreText bold color={Color.Base}>Correct access to organization Extensions</CoreText>
        <CoreText bold color={Color.Base}>Reject disallowed words in Extension name</CoreText>
        <CoreText className="release-notes-dialog__details">This includes instances of "Twitch", "Glitch", and
          "Extension".</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 1.2.3</CoreText>
        <CoreText bold color={Color.Base}>Correct clearing of cookies</CoreText>
        <CoreText className="release-notes-dialog__details">The Electron documentation at electronjs.org is incorrect.  The
          Electron documentation at github.com/electron/electron is correct.  The "storages" field of the "options" object
          parameter of the clearStorageData method must be an array of strings, not a single string.</CoreText>
        <CoreText bold color={Color.Base}>Use context box sizing for panel views</CoreText>
        <CoreText className="release-notes-dialog__details">This prevents losing a pixel on each side due to the enclosing
          border.</CoreText>
        <CoreText bold color={Color.Base}>Allow specified URLs to open a new window</CoreText>
        <CoreText className="release-notes-dialog__details">The Developer Rig will use the URLs found in the "Whitelist config
          Urls" and "Whitelist panel Urls" of the "Capabilities" section of the selected version of your extension.</CoreText>
        <CoreText bold color={Color.Base}>Enable horizontal scrolling</CoreText>
        <CoreText className="release-notes-dialog__details">A horizontal scrollbar will appear if the views are too
          wide.</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 1.2.2</CoreText>
        <CoreText bold color={Color.Base}>Update several dependencies</CoreText>
        <CoreText className="release-notes-dialog__details">The front end of the Developer Rig is now using React 16.9, the CRA 3.1
          scripts, and TypeScript 3.2.</CoreText>
        <CoreText bold color={Color.Base}>Correct a typographical error</CoreText>
        <CoreText className="release-notes-dialog__details">If attempting to run a custom front-end command fails, report that the
          front end failed instead of that the back end failed.</CoreText>
        <CoreText bold color={Color.Base}>Clear cookies upon sign-out</CoreText>
        <CoreText className="release-notes-dialog__details">Signing out will require signing back in with credentials.</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 1.2.1</CoreText>
        <CoreText bold color={Color.Base}>Append organization extensions into extension list</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 1.2.0</CoreText>
        <CoreText bold color={Color.Base}>Remove old component design</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 1.1.4</CoreText>
        <CoreText bold color={Color.Base}>Enable new component design in "view in browser"</CoreText>
        <CoreText bold color={Color.Base}>Always fetch the configuration</CoreText>
        <CoreText className="release-notes-dialog__details">Since it's possible for the configuration to change outside of the
          Developer Rig, fetch it from Twitch instead of using a local instance.</CoreText>
        <CoreText bold color={Color.Base}>Reload configuration upon manifest refresh</CoreText>
        <CoreText bold color={Color.Base}>Reload extension frame upon view refresh</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 1.1.3</CoreText>
        <CoreText bold color={Color.Base}>Enable self-signed certificates</CoreText>
        <CoreText className="release-notes-dialog__details">The Developer Rig will display a dialog asking for an exception for any
          certificate considered invalid.  The exception is scoped to either the URL or the origin.  You may save such exceptions
          in the project file.  Otherwise, they last for the duration of that session for that project.</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 1.1.2</CoreText>
        <CoreText bold color={Color.Base}>Force a hard reload with the refresh button</CoreText>
        <CoreText bold color={Color.Base}>Correct component view creation properties</CoreText>
        <CoreText className="release-notes-dialog__details">They're now back to the way they were before the new developer
          site.  This ensures component views aren't adversely affected.  For instance, the Hello World example extension was
          partially hidden.</CoreText>
        <CoreText bold color={Color.Base}>Update GQL mutation used for creating new extension</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 1.1.1</CoreText>
        <CoreText bold color={Color.Base}>Add translucent backdrop to new component views</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 1.1.0</CoreText>
        <CoreText bold color={Color.Base}>Add the new component extension view</CoreText>
        <CoreText className="release-notes-dialog__details">See <CoreLink ariaLabel="ReleaseNotesDialog:RFC 0012" linkTo={rfc0012Url}>RFC 0012</CoreLink> for more
          information.</CoreText>
        <CoreText bold color={Color.Base}>Improve overlay sizes</CoreText>
        <CoreText className="release-notes-dialog__details">They're now 16x9 and have a range of expected sizes.</CoreText>
        <CoreText bold color={Color.Base}>Add missing features</CoreText>
        <CoreText className="release-notes-dialog__details">The isBitsEnabled and isSubscriptionStatusAvailable features are now
          configurable along with the isChatEnabled feature.</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 1.0.3</CoreText>
        <CoreText bold color={Color.Base}>Provide an appropriate anchor parameter</CoreText>
        <CoreText className="release-notes-dialog__details">The configuration and live configuration (dashboard) extension
          views get a valid anchor.  The user selects one when creating such a view if there are more than one anchor
          available.</CoreText>
        <CoreText bold color={Color.Base}>Validate custom extension sizes</CoreText>
        <CoreText bold color={Color.Base}>Enable "Enter" key in dialogs</CoreText>
        <CoreText bold color={Color.Base}>Assume examples use HTTP instead of HTTPS</CoreText>
        <CoreText className="release-notes-dialog__details">The repositories for the examples have been updated.</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 1.0.2</CoreText>
        <CoreText bold color={Color.Base}>Correct the monetization link</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 1.0.1</CoreText>
        <CoreText bold color={Color.Base}>Enable opening a project in Visual Studio Code</CoreText>
        <CoreText className="release-notes-dialog__details">If you have Visual Studio Code installed in the usual place, a button
          will appear in the Project Details view.  When clicked, Visual Studio Code will open with the project folder.</CoreText>
        <CoreText className="release-notes-dialog__details">By "usual" I mean /Applications on macOS and %LOCALAPPDATA% on
          Windows.</CoreText>
        <CoreText bold color={Color.Base}>Add buttons to clear logs</CoreText>
        <CoreText className="release-notes-dialog__details">There are text buttons in the secondary window for the back- and
          front-end logs and another icon button in the console for its logs.</CoreText>
        <CoreText bold color={Color.Base}>Enable channel display behind components and overlays</CoreText>
        <CoreText className="release-notes-dialog__details">When creating a view for a component or overlay, you may specify a
          channel to display behind it.  The Developer Rig will remember this choice for future component views.  Audio is muted
          by default.  However, depending on your browser (e.g. Firefox), you might want to mute before using "view in
          browser".</CoreText>
        <CoreText bold color={Color.Base}>Reduce opacity of console minimize button</CoreText>
        <CoreText className="release-notes-dialog__details">This ensures text isn't adversely obscured.</CoreText>
        <CoreText bold color={Color.Base}>Zip the Windows executable</CoreText>
        <CoreText className="release-notes-dialog__details">Since the short links redirect to bit.ly, and since bit.ly refuses to
          serve files with an EXE extension, put the installer in a Zip file.</CoreText>
        <CoreText bold color={Color.Base}>Create favicon.png</CoreText>
        <CoreText className="release-notes-dialog__details">This is for Linux.  It is not currently used since none of the steps
          documented at electron.build results in a recognized icon.</CoreText>
        <CoreText bold color={Color.Base}>Report Git and NPM failures</CoreText>
        <CoreText className="release-notes-dialog__details">If Git or NPM fails, provide its exit code and standard error output
          in the exception thrown to the front end.  The front end will report the error and provide the text of it in the
          Developer Tools console.</CoreText>
        <CoreText bold color={Color.Base}>Improve extension secret fetch retry</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 1.0.0</CoreText>
        <CoreText bold color={Color.Base}>Restore previous component defaults</CoreText>
        <CoreText bold color={Color.Base}>Dismiss context menu upon outer click</CoreText>
        <CoreText bold color={Color.Base}>Improve "Refresh" button vertical alignment</CoreText>
        <CoreText bold color={Color.Base}>Ensure context menu is hidden under user drop-down</CoreText>
        <CoreText bold color={Color.Base}>Remove documentation link from user drop-down menu</CoreText>
        <CoreText className="release-notes-dialog__details">There's one in the RigNav component on the left.</CoreText>
        <CoreText bold color={Color.Base}>Enlarge the code selection balloon</CoreText>
        <CoreText className="release-notes-dialog__details">This prevents enclosed text from wrapping.</CoreText>
        <CoreText bold color={Color.Base}>Update text in several views</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 0.9.13</CoreText>
        <CoreText bold color={Color.Base}>Serve an updated Coordinator</CoreText>
        <CoreText className="release-notes-dialog__details">This provides the subscriptionStatus field that is expected by the
          newest twitch-ext.min.js file.</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 0.9.12</CoreText>
        <CoreText bold color={Color.Base}>Save project file only upon successful initialization</CoreText>
        <CoreText bold color={Color.Base}>Use "Hide" instead of "Trash" for "Close Project"</CoreText>
        <CoreText bold color={Color.Base}>Use "tutorial" instead of "guide"</CoreText>
        <CoreText bold color={Color.Base}>Add activation buttons to Extension Views</CoreText>
        <CoreText bold color={Color.Base}>Include error messages in the "create project" flow</CoreText>
        <CoreText bold color={Color.Base}>Set the project name to the extension name</CoreText>
        <CoreText bold color={Color.Base}>Enhance project name placeholder</CoreText>
        <CoreText className="release-notes-dialog__details">If the user is creating an extension when creating a project,
          tell them the name of the extension will be the name of the project.</CoreText>
        <CoreText bold color={Color.Base}>Add ellipses to project names where necessary</CoreText>
        <CoreText className="release-notes-dialog__details">If a project name is too long to show in the tab, truncate it
          and add an ellipsis.  The full name is available in the hover text.</CoreText>
        <CoreText bold color={Color.Base}>Allow missing back-end command and folder name</CoreText>
        <CoreText className="release-notes-dialog__details">React was complaining about a component switching between controlled
          and uncontrolled.  This happened because back-end data were undefined.</CoreText>
        <CoreText bold color={Color.Base}>Show a "Loading" message</CoreText>
        <CoreText bold color={Color.Base}>Add text to inform of example code requirements</CoreText>
        <CoreText className="release-notes-dialog__details">All example projects require Node since all of them use NPM.
          The Animal Facts example also requires Go 1.10+.</CoreText>
        <CoreText bold color={Color.Base}>Correct RigNav child alignment</CoreText>
        <CoreText bold color={Color.Base}>Correct "Need Help?" pointer</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 0.9.11</CoreText>
        <CoreText bold color={Color.Base}>Include Linux as a target</CoreText>
        <CoreText bold color={Color.Base}>Update Discord icon</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 0.9.10</CoreText>
        <CoreText bold color={Color.Base}>Correct check for first argument</CoreText>
        <CoreText className="release-notes-dialog__details">This addresses the INVALID_ARG_TYPE error.</CoreText>
        <CoreText bold color={Color.Base}>Set the project name</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 0.9.9</CoreText>
        <CoreText bold color={Color.Base}>Add new "Getting Started" example extension option</CoreText>
        <CoreText className="release-notes-dialog__details">The implementation is the same as "Hello World + PubSub" (renamed
          from "Hello World") except it doesn't use PubSub.  The documentation is very different and more
          beginner-friendly.</CoreText>
        <CoreText bold color={Color.Base}>Update links to the new Twitch developer site</CoreText>
        <CoreText bold color={Color.Base}>Use absolute paths for front- and back-end folders</CoreText>
        <CoreText bold color={Color.Base}>Allow pointer events in no-no zones</CoreText>
        <CoreText bold color={Color.Base}>Update UI</CoreText>
        <CoreText className="release-notes-dialog__details">All views have received some new treatments.</CoreText>
        <CoreText bold color={Color.Base}>Implement new "Create Project" flow</CoreText>
        <CoreText bold color={Color.Base}>Create and use WelcomePage component</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 0.9.8</CoreText>
        <CoreText bold color={Color.Base}>Update Project Details view UI</CoreText>
        <CoreText bold color={Color.Base}>Ensure configuration has defined values</CoreText>
        <CoreText bold color={Color.Base}>Correct ebs invocation command</CoreText>
        <CoreText className="release-notes-dialog__details">On *NIX systems, it needs the current directory as part of the
            command.</CoreText>
        <CoreText bold color={Color.Base}>Update upon start-up if available</CoreText>
        <CoreText className="release-notes-dialog__details">Display a "downloading update" message while doing so.</CoreText>
        <CoreText bold color={Color.Base}>Remove "Update Available" from user drop-down list</CoreText>
        <CoreText bold color={Color.Base}>Ensure presence of CSP before use</CoreText>
        <CoreText bold color={Color.Base}>Add "game" to the "Edit Context" drop-down list</CoreText>
        <CoreText bold color={Color.Base}>Ensure left navigation is free of scroll bars</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 0.9.7</CoreText>
        <CoreText bold color={Color.Base}>Correct width of panel extensions</CoreText>
        <CoreText bold color={Color.Base}>Update Configuration Service view UI</CoreText>
        <CoreText bold color={Color.Base}>Remove help from the Project Details view</CoreText>
        <CoreText className="release-notes-dialog__details">Help is now in the left navigation.</CoreText>
        <CoreText bold color={Color.Base}>Move help into the left navigation</CoreText>
        <CoreText bold color={Color.Base}>Implement Edit Context</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 0.9.6</CoreText>
        <CoreText bold color={Color.Base}>Save and restore the window state</CoreText>
        <CoreText className="release-notes-dialog__details">This is stored in `~/Library/Application
          Support/developer-rig/config.json` on macOS and in `%USERPROFILE%\AppData\Roaming\developer-rig\config.json` on
            Windows.</CoreText>
        <CoreText bold color={Color.Base}>Update to Electron 4.0.2</CoreText>
        <CoreText bold color={Color.Base}>Account for Hosted Test</CoreText>
        <CoreText className="release-notes-dialog__details">If an extension is in Hosted Test, Twitch is serving it.  In this
            case, the Developer Rig will not attempt to host the front end.</CoreText>
        <CoreText className="release-notes-dialog__details">Since Twitch requires all extensions to use SSL to access their
            back ends, the Developer Rig provides an option to override this.  This affects the Developer Rig only.</CoreText>
        <CoreText className="release-notes-dialog__details">Since the JavaScript of the Hello World example extension uses
          its hosting page's protocol to construct its back-end access URL, that example won't work without either enabling
            SSL in its back end or changing its front-end code to use HTTP.</CoreText>
        <CoreText bold color={Color.Base}>Validate the path name before inspecting it</CoreText>
        <CoreText className="release-notes-dialog__details">This addresses a crash that occurs upon an attempted
          sign-out.</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 0.9.5</CoreText>
        <CoreText bold color={Color.Base}>Change "Delete Project" to "Close Project"</CoreText>
        <CoreText className="release-notes-dialog__details">The word "close" describes the operation more appropriately.</CoreText>
        <CoreText bold color={Color.Base}>Ensure child process clean-up</CoreText>
        <CoreText className="release-notes-dialog__details">This addresses a rare, macOS-only issue where the project tabs
            became inactive.</CoreText>
        <CoreText bold color={Color.Base}>Run back end in its directory</CoreText>
        <CoreText className="release-notes-dialog__details">BREAKING CHANGE:  if a directory is given in Back-end Files
          Location, the command specified in Back-end Run Command is now run in that directory instead of the directory given
          in Project Folder.  This is a BREAKING CHANGE if there is a path to your back end that is relative to your Project
          Folder in Back-end Run Command.  This change affects the Hello World example extension.  This behavior now matches
            that of Front-end Host Command.</CoreText>
        <CoreText bold color={Color.Base}>Ensure disabled buttons are inactive</CoreText>
        <CoreText bold color={Color.Base}>Implement "view in browser"</CoreText>
        <CoreText className="release-notes-dialog__details">Display an option in each extension view's menu to view it in the
            default desktop browser.  The Developer Rig will act as the Web server for that session.</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 0.9.4</CoreText>
        <CoreText bold color={Color.Base}>Correct sign-in view CSS</CoreText>
        <CoreText className="release-notes-dialog__details">The Twitch sign-in page was restricted to the left half of the
            window.</CoreText>
        <CoreText bold color={Color.Base}>Use an OS-assigned port instead of a fixed port</CoreText>
        <CoreText className="release-notes-dialog__details">The internal Web service endpoint used a fixed port.  Although
          unlikely, it might conflict with some other service, preventing either that service or the Developer Rig from
            running properly.  The Developer Rig now uses an OS-assigned port to serve internal assets.</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 0.9.3</CoreText>
        <CoreText bold color={Color.Base}>Change product name to "Twitch Developer Rig"</CoreText>
        <CoreText bold color={Color.Base}>Show full configuration service view</CoreText>
        <CoreText className="release-notes-dialog__details">If an extension is not configured for hosted configuration, display
            a message describing how to configure the extension for it.</CoreText>
        <CoreText bold color={Color.Base}>Ignore "Up To Date" clicks</CoreText>
        <CoreText className="release-notes-dialog__details">If there is no update available, don't try to get one since it causes
            the window to minimize on macOS.</CoreText>
        <CoreText bold color={Color.Base}>Add a toggle to collapse the left navigation</CoreText>
        <CoreText bold color={Color.Base}>Get full hosting status upon reload</CoreText>
        <CoreText className="release-notes-dialog__details">If the Developer Rig is hosting the front end, as it does for the
          Hello World example extension, it did not reconnect to the hosted front end after a reload (from the View menu).
            This commit will ensure it gets the state needed to recognize the hosted front end is still running.</CoreText>
        <CoreText bold color={Color.Base}>Ensure correct version upon project change</CoreText>
        <CoreText className="release-notes-dialog__details">Upon changing projects, ensure the state of the Project Details view
            is set to match the corresponding fields of the project.</CoreText>
        <CoreText bold color={Color.Base}>Add a secondary window</CoreText>
        <CoreText className="release-notes-dialog__details">This window will display the standard error and standard output of
            the back-end and front-end processes.</CoreText>
        <CoreText bold color={Color.Base}>Use password type for secret in open project dialog</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 0.9.2</CoreText>
        <CoreText bold color={Color.Base}>Reduce extension token lifetime</CoreText>
        <CoreText className="release-notes-dialog__details">It now expires in one day.</CoreText>
        <CoreText bold color={Color.Base}>Save formatted project files</CoreText>
        <CoreText className="release-notes-dialog__details">This enables better differencing in source control systems.</CoreText>
        <CoreText bold color={Color.Base}>Toggle developer tools in a context menu</CoreText>
        <CoreText className="release-notes-dialog__details">Right-click anywhere in the application window except in the sign-in
            screen or an extension view to open the context menu.</CoreText>
        <CoreText bold color={Color.Base}>Change secret input type to password</CoreText>
        <CoreText bold color={Color.Base}>Save the extension view channel ID in local storage</CoreText>
        <CoreText className="release-notes-dialog__details">It is used to remember the channel ID in the "Create New View"
            dialog so subsequent view additions will default to it.</CoreText>
        <CoreText bold color={Color.Base}>Include the current user as an option</CoreText>
        <CoreText className="release-notes-dialog__details">The configuration service and extension views now default to the
            current user instead of the Developer Rig user.</CoreText>
        <CoreText bold color={Color.Base}>Add the Release Notes dialog</CoreText>
        <CoreText className="release-notes-dialog__details">You're looking at it now.</CoreText>
        <CoreText bold color={Color.Base}>Display a console usage message the first time</CoreText>
        <CoreText bold color={Color.Base}>Display a message for non-hosted configuration</CoreText>
        <CoreText bold color={Color.Base}>Display a message instead of disabling monetization</CoreText>
        <CoreText bold color={Color.Base}>Use the labels to identify views in the console</CoreText>
        <CoreText className="release-notes-dialog__details">The console displays the text entered into the "View Label" text
            box in the "Create New View" as the header for each line.  That header is now in a distinguishing color.</CoreText>
        <CoreText bold color={Color.Base}>Allow spaces in project names</CoreText>
        <CoreText className="release-notes-dialog__details">Spaces were already allowed but the only way to get a space into
            a project name was insert it in between non-space characters.  Now you can type normally.</CoreText>
        <CoreText bold color={Color.Base}>Add an About box for Windows</CoreText>
        <CoreText className="release-notes-dialog__details">It's in the Help menu.  It displays the current version.</CoreText>
      </div>
      <div className="release-notes-dialog__section">
        <CoreText bold color={Color.Base} fontSize={FontSize.Size4}>Release 0.9.1</CoreText>
        <CoreText bold color={Color.Base}>Account for scroll bars in Console output</CoreText>
        <CoreText className="release-notes-dialog__details">This ensures all text is visible in the console.</CoreText>
        <CoreText bold color={Color.Base}>Update Rig configuration upon configuration save</CoreText>
        <CoreText className="release-notes-dialog__details">Note that this does not refresh an extension's knowledge of its
          configuration since configuration updates do not affect running extensions.  The extension is updated only upon
            refresh.</CoreText>
        <CoreText bold color={Color.Base}>Send position updates to component extensions</CoreText>
        <CoreText className="release-notes-dialog__details">Changing a component extension's position now invokes
            onPositionChanged.</CoreText>
        <CoreText bold color={Color.Base}>Correct EditViewDialog position editing</CoreText>
        <CoreText className="release-notes-dialog__details">This ensures non-numeric positions are rejected.</CoreText>
        <CoreText bold color={Color.Base}>Ensure all dialogs have default actions</CoreText>
        <CoreText className="release-notes-dialog__details">This enables using the Enter key to confirm a dialog.</CoreText>
        <CoreText bold color={Color.Base}>Modify styles to prevent UI glitches</CoreText>
        <CoreText className="release-notes-dialog__details">An extension's context menu no longer shows through the upper-right
            drop-down menu.</CoreText>
        <CoreText bold color={Color.Base}>Add LoadFailureView</CoreText>
        <CoreText className="release-notes-dialog__details">This allows locating or removing a project whose JSON file cannot
            be found at its original location.</CoreText>
        <CoreText bold color={Color.Base}>Normalize all dialog UI</CoreText>
        <CoreText className="release-notes-dialog__details">All dialogs now have the same structure and styling.</CoreText>
        <CoreText bold color={Color.Base}>Disable file location modification if running</CoreText>
        <CoreText className="release-notes-dialog__details">This prevents changes to a project while the back end or front
            end is running.</CoreText>
      </div>
    </Dialog>
  );
}
