import { setupShallowTest } from '../tests/enzyme-util/shallow';
import { RigNav } from '.';
import { UserDropdown } from '../user-dropdown';
import { NavItem } from '../rig-nav';

const defaultGenerator = () => ({
  currentView: NavItem.ProjectOverview,
  isOpen: true,
  onToggle: jest.fn(),
  selectView: jest.fn(),
  showReleaseNotes: jest.fn(),
});

const setupShallow = setupShallowTest(RigNav, defaultGenerator);

describe('<RigNav />', () => {
  it('renders correctly', () => {
    const { wrapper } = setupShallow();
    expect(wrapper.debug()).toMatchSnapshot();
  });

  it('correct css classes are set when things are selected', () => {
    const { wrapper } = setupShallow();
    wrapper.find('.rig-nav__link').forEach((tab) => {
      const event = { currentTarget: { getAttribute: jest.fn((name: string) => tab.render().attr()[name]) }, stopPropagation: jest.fn() };
      tab.simulate('click', event);
      expect(wrapper.find('button.rig-nav__link--selected')).toHaveLength(1);
    });
  });

  it('renders user dropdown if session exists', () => {
    const { wrapper } = setupShallow();
    expect(wrapper.find(UserDropdown));
  });
});
