import { configure } from 'enzyme';
import Adapter from 'enzyme-adapter-react-16';

mockGlobals();
window['extension-coordinator'] = newMockCoordinator();
const electronMock = createElectronMock();
window.electron = electronMock;
configure({ adapter: new Adapter() });

function mockGlobals() {
  const userSession = {
    authToken: 'authToken',
    displayName: 'displayName',
    expiration: Date.parse('3333-03-03'),
    id: 'id',
    login: 'login',
    profileImageUrl: 'profileImageUrl',
  };
  localStorage = createLocalStorage();
  localStorage.setItem('rigLogin', JSON.stringify(userSession));

  window.rig = {};
  window.rig.history = [];
  window.location = {};

  window['extension-coordinator'] = newMockCoordinator();
}

function createLocalStorage() {
  const localStorage = {};

  return {
    getItem: (key) => {
      return key in localStorage ? localStorage[key] : null;
    },
    removeItem: (key) => {
      delete localStorage[key];
    },
    setItem: (key, value) => {
      localStorage[key] = value;
    },
  };
}

function newMockCoordinator() {
  return {
    ExtensionMode: {
      Viewer: 'viewer',
      Dashboard: 'dashboard',
      Config: 'config',
    },
    ExtensionPlatform: {
      Web: 'web',
      Mobile: 'mobile',
    },
    ExtensionAnchor: {
      Panel: 'panel',
      Overlay: 'videoOverlay',
      Component: 'component',
    },
  };
}

function createElectronMock() {
  return {
    basename: (path) => path.split('/').pop() || '/',
    dirname: (path) => path.substr(path.lastIndexOf('/') + 1) || '/',
    env: {
      RIG_CLIENT_ID: 'RIG_CLIENT_ID',
      RIG_REDIRECT_URL: 'http://rig_redirect_url.local',
    },
    existsSync: (_path) => true,
    ipcRenderer: {
      on: jest.fn(),
      once: jest.fn(mockOnce),
      removeListener: jest.fn(),
      send: jest.fn(mockSend),
    },
    resolve: (...args) => args.join('/'),
    openExternal: jest.fn(),
  };
}

let currentListener, currentPath;

function mockOnce(channel, listener) {
  expect(channel.startsWith('api/')).toBeTruthy();
  expect(currentListener).toBeUndefined();
  currentListener = listener;
  currentPath = channel.substr(3);
}

function mockSend(channel, path, body) {
  expect(channel).toBe('api');
  expect(currentListener).toBeDefined();
  expect(currentPath).toBe(path);
  electronMock.request = { path, body };
  let listener = currentListener;
  currentListener = undefined;
  setTimeout(() => electronMock.response === 'error' ?
    listener({}, electronMock.response, undefined) :
    listener({}, undefined, electronMock.response));
}
