import { ExtensionManifest } from '../../core/models/manifest';
import { RigExtensionView, ViewerType, ExtensionType } from '../../core/models/rig';
import { ExtensionAnchor, ExtensionMode, ExtensionObject, ExtensionState } from 'extension-coordinator';
import { MobileOrientation } from '../../constants/mobile';

const clientId = 'clientId';

// The fields that are comments are those that appear in a live manifest but
// are no longer used.
export function createExtensionManifestForTest(): ExtensionManifest {
  return {
    ...createCommonFields(),
    //anchor: 'panel',
    //assetUrls: [],
    //canInstall: true,
    //configUrl: 'https://localhost/config',
    configurationLocation: 'custom',
    //eulaTosUrl: 'http://localhost/eula',
    hasChatSupport: true,
    iconUrls: {
      '100x100': 'https://localhost/medium',
      '24x24': 'https://localhost/small',
      '300x200': 'https://localhost/large',
    },
    id: clientId,
    //installationCount: -42,
    //liveConfigUrl: 'https://localhost/live_config',
    //panelHeight: 0,
    //privacyPolicyUrl: 'http://localhost/pp',
    //requiredBroadcasterAbilities: [],
    //screenshotUrls: [
    //  'https://localhost/screenshotUrls,'
    //],
    //subscriptionsSupportLevel: 'none',
    //supportEmail: 'support@localhost',
    //viewerUrl: 'https://localhost/panel',
    //viewerUrls: {
    //  component: 'https://localhost/video_component',
    //  mobile: 'https://localhost/mobile',
    //  panel: 'https://localhost/panel',
    //  videoOverlay: 'https://localhost/video_overlay',
    //},
  };
}

// This is a copy of the above manifest with changes necessary to adhere to the
// ExtensionObject type given in .../src/core/models/manifest.ts.
export function createExtensionObjectForTest(port?: number): ExtensionObject {
  const authority = port ? `http://localhost:${port}` : 'https://localhost';
  return {
    ...createCommonFields(port),
    clientId,
    iconUrls: {
      discoverySplash: `${authority}/large`,
      square100: `${authority}/medium`,
      square24: `${authority}/small`,
    },
    id: `${clientId}:0`,
    token: 'token',
  };
}

export function createViewsForTest(numOfViews: number, type: ExtensionType, viewerType: ViewerType, extras?: any): RigExtensionView[] {
  const extViews: RigExtensionView[] = [];

  for (let i = 0; i < numOfViews; i++) {
    const view: RigExtensionView = {
      label: 'label',
      channelId: 'twitch',
      configurationAnchor: type === ExtensionMode.Config || type === ExtensionMode.Dashboard ? ExtensionAnchor.Panel : type as ExtensionAnchor,
      displayChannelName: 'twitchdev',
      id: (extViews.length + 1).toString(),
      type,
      linked: false,
      linkedUserId: '',
      opaqueId: 'ARIGopaqueId',
      viewerType,
      isPopout: true,
      features: {
        isBitsEnabled: true,
        isChatEnabled: true,
        isSubscriptionStatusAvailable: false,
      },
      frameSize: {
        height: 99,
        width: 99,
      },
      orientation: MobileOrientation.Default,
    };
    if (extras && extras.orientation) {
      view.orientation = extras.orientation;
    }
    extViews.push(view);
  }

  return extViews;
}

function createCommonFields(port?: number) {
  const authority = port ? `http://localhost:${port}` : 'https://localhost';
  return {
    authorName: 'authorName',
    bitsEnabled: true,
    description: 'description',
    iconUrl: `${authority}/medium`,
    name: 'name',
    requestIdentityLink: true,
    sku: 'sku',
    state: ExtensionState.Testing,
    summary: 'summary',
    vendorCode: 'vendorCode',
    version: '0.0.1',
    viewerSummary: '',
    views: {
      component: {
        aspectHeight: 5,
        aspectRatioX: 6,
        aspectRatioY: 5,
        aspectWidth: 6,
        autoScale: false,
        canLinkExternalContent: false,
        scalePixels: 1024,
        //size: 0,
        targetHeight: 10000,
        viewerUrl: `${authority}/video_component`,
        zoom: false,
        zoomPixels: 0,
      },
      config: {
        canLinkExternalContent: false,
        viewerUrl: `${authority}/config`,
      },
      liveConfig: {
        canLinkExternalContent: false,
        viewerUrl: `${authority}/live_config`,
      },
      mobile: {
        viewerUrl: `${authority}/mobile`,
      },
      panel: {
        canLinkExternalContent: true,
        height: 300,
        viewerUrl: `${authority}/panel`,
      },
      videoOverlay: {
        viewerUrl: `${authority}/video_overlay`,
        canLinkExternalContent: false,
      },
    },
    whitelistedConfigUrls: [
      `${authority}/allowed_config`,
    ],
    whitelistedPanelUrls: [
      `${authority}/allowed_panel`,
    ],
  };
}
