import * as React from 'react';
import { shallow, ShallowRendererProps } from 'enzyme';

/**
 * Builds the shallow wrapper for a component given defaults set in a test suite,
 * and allowing overrides for each case.
 * @param {*} Component
 * @param {*} generator
 * @param {*} shallowOptions
 */
export function setupShallowTest<Props>(Component: React.ComponentClass<Props>, generator: () => Props, shallowOptions?: ShallowRendererProps) {
  return (propOverrides?: Partial<Props>) => {
    const combinedProps = Object.assign({}, generator(), propOverrides);
    return {
      props: combinedProps,
      wrapper: shallow((<Component {...combinedProps} />), shallowOptions),
    }
  }
}
