export type ChangeEventFn = (_: { currentTarget: { checked?: boolean; name: string; value?: string; }; }) => void;

export function mockFetchForExtensionManifest() {
  return Promise.resolve({
    ok: true,
    json: () => Promise.resolve({
      version: 1,
      id: 'clientid',
      views: {},
    }),
  });
}

export function mockFetchForExtensionSecret(count: number) {
  return Promise.resolve({
    ok: true,
    json: () => Promise.resolve({
      secrets: count ? [{
        active: '03-03-2003',
        content: {},
      }] : [],
    }),
  });
}

export function mockFetchForUserInfo() {
  return Promise.resolve({
    ok: true,
    json: () => Promise.resolve({
      data: [{
        login: 'test',
        profile_image_url: 'test.png',
      }],
    }),
  });
}

export function mockEmptyResponse() {
  return Promise.resolve({ json: () => Promise.resolve('') });
}

export function mockFetch400() {
  return Promise.resolve({
    status: 400,
    json: () => Promise.resolve({ message: '400 error' }),
  });
}

export function mockFetch500() {
  return Promise.resolve({
    status: 500,
    json: () => Promise.resolve({ message: '500 error' }),
  });
}

export function mockFetchError() {
  return Promise.reject('Fake error');
}

export function mockFetchProducts() {
  return Promise.resolve({
    json: () => Promise.resolve({
      products: [{
        domain: 'twitch.ext.mock',
        sku: 'test1',
        displayName: 'Test 1',
        cost: { amount: 1, type: 'bits' },
        inDevelopment: true,
        broadcast: false,
      },
      {
        domain: 'twitch.ext.mock',
        sku: 'test2',
        displayName: 'Test 2',
        cost: { amount: 100, type: 'bits' },
        inDevelopment: false,
        broadcast: false,
      }],
    }),
  });
}

export function mockSaveProduct() {
  return Promise.resolve({
    status: 204,
    json: () => Promise.resolve({}),
  });
}

export async function timeout(ms?: number) {
  await new Promise((resolve, _reject) => setTimeout(resolve, ms));
}
