import { setupShallowTest } from '../tests/enzyme-util/shallow';
import { UserDropdown, Props } from './component';
import { LocalStorage } from '../util/local-storage';

describe('<UserDropdown />', () => {
  const defaultGenerator = (): Props => ({
    session: {
      authToken: 'test',
      displayName: 'test',
      email: 'email@email.com',
      expiration: 9999999999999,
      id: 'test',
      login: 'test',
      profileImageUrl: 'test.png',
    },
    logout: jest.fn(),
  });
  const setupRenderer = setupShallowTest(UserDropdown, defaultGenerator);

  it('renders correctly', () => {
    const { wrapper } = setupRenderer();
    expect(wrapper.debug()).toMatchSnapshot();
  });

  it('does not render if session undefined', () => {
    const { wrapper } = setupRenderer({ session: undefined });
    expect(wrapper.html()).toBeNull();
  });

  it('signs out', () => {
    const { props, wrapper } = setupRenderer();
    wrapper.find('DropdownMenu').dive().find('button').simulate('click');
    const localStorage = new LocalStorage();
    expect(localStorage.rigLogin).toBeUndefined();
    expect(props.logout).toHaveBeenCalledTimes(1);
  });
});
