import * as React from 'react';
import { UserSession } from '../core/models/user-session';
import './component.sass';
import { LocalStorage } from '../util/local-storage';
import { DropdownMenu } from '../dropdown-menu';

export interface Props {
  session: UserSession;
  logout: () => void;
}

interface State {
  open: boolean;
}

export class UserDropdown extends React.Component<Props, State> {
  public state: State = {
    open: false,
  }

  private signOut = () => {
    const localStorage = new LocalStorage();
    localStorage.rigLogin = undefined;
    this.props.logout();
  }

  public render() {
    if (!this.props.session) {
      return null;
    }
    const { login, profileImageUrl } = this.props.session;

    return (
      <div className="user-dropdown">
        <DropdownMenu
          action={
            <div className="user-dropdown__tab">
              <img alt={login} className="user-dropdown__image" src={profileImageUrl} />
            </div>
          }
          menu={
            <>
              <div className="user-dropdown__menu-item">
                <svg width="18" height="18" viewBox="0 0 18 18" xmlns="http://www.w3.org/2000/svg">
                  <path d="M14.4 8.10005H13.5V6.30005C13.5 5.30645 12.6936 4.50005 11.7 4.50005H9.90005V3.60005C9.90005 2.60645 9.09365 1.80005 8.10005 1.80005C7.10645 1.80005 6.30005 2.60645 6.30005 3.60005V4.50005H3.60005C2.60645 4.50005 1.80005 5.30645 1.80005 6.30005V8.10005H2.70005C3.69365 8.10005 4.50005 8.90645 4.50005 9.90005C4.50005 10.8936 3.69365 11.7 2.70005 11.7H1.80005V14.4C1.80005 15.3936 2.60645 16.2 3.60005 16.2H6.30005V15.2433C6.30005 14.2497 7.10645 13.4433 8.10005 13.4433C9.09365 13.4433 9.90005 14.2497 9.90005 15.2433V16.2H11.7C12.6936 16.2 13.5 15.3936 13.5 14.4V11.7H14.4C15.3936 11.7 16.2 10.8936 16.2 9.90005C16.2 8.90645 15.3936 8.10005 14.4 8.10005Z" />
                </svg>
                <a aria-label="UserDropdown:Extensions Dashboard" className="user-dropdown__menu-item-action" href="https://dev.twitch.tv/console/extensions">
                  <span className="user-dropdown__menu-item-action">Extensions Dashboard</span>
                </a>
              </div>
              <div className="user-dropdown__menu-item">
                <svg width="18" height="18" viewBox="0 0 18 18" xmlns="http://www.w3.org/2000/svg">
                  <path d="M16.1868 3.44527C16.113 3.02137 15.744 2.70007 15.3003 2.70007H2.70029C2.25569 2.70007 1.88669 3.02137 1.81289 3.44527L1.80029 3.43447V7.20007V10.8001C1.80029 11.2978 2.20259 11.7001 2.70029 11.7001H11.964L15.4317 15.1678C15.5181 15.2542 15.6333 15.3001 15.7503 15.3001C15.8079 15.3001 15.8673 15.2884 15.9222 15.2659C16.0905 15.1966 16.2003 15.0319 16.2003 14.8501V11.7001V11.2501V7.20007V3.43447L16.1868 3.44527Z" />
                </svg>
                <a aria-label="UserDropdown:Give Feedback" className="user-dropdown__menu-item-action" href="mailto:developers@twitch.tv">
                  <span className="user-dropdown__menu-item-action">Give Feedback</span>
                </a>
              </div>
              <div className="user-dropdown__divider"></div>
              <div className="user-dropdown__menu-item">
                <svg width="18" height="18" viewBox="0 0 18 18" xmlns="http://www.w3.org/2000/svg">
                  <path d="M10.7586 10.7991V12.6333C10.7586 12.9969 10.9782 13.3263 11.3139 13.4649C11.6505 13.6044 12.0375 13.527 12.2949 13.2696L15.9363 9.64706C16.1046 9.47786 16.2 9.24926 16.2 9.01076C16.2 8.77136 16.1046 8.54276 15.9363 8.37446L12.2949 4.75106C12.0375 4.49366 11.6505 4.41716 11.3139 4.55666C10.9782 4.69526 10.7586 5.02376 10.7586 5.38736V7.20446L6.28285 7.20446C5.78605 7.20446 5.38285 7.60676 5.38285 8.10446V9.89906C5.38285 10.3959 5.78605 10.7991 6.28285 10.7991H10.7586ZM9.89968 15.3C9.89968 15.7977 9.49648 16.2 8.99968 16.2H2.69968C2.20288 16.2 1.79968 15.7977 1.79968 15.3V2.70005C1.79968 2.20235 2.20288 1.80005 2.69968 1.80005L8.99968 1.80005C9.49648 1.80005 9.89968 2.20235 9.89968 2.70005C9.89968 3.19775 9.49648 3.60005 8.99968 3.60005L3.59968 3.60005V14.4H8.99968C9.49648 14.4 9.89968 14.8023 9.89968 15.3Z" />
                </svg>
                <button aria-label="UserDropdown:Sign Out" className="user-dropdown__menu-item-action" onClick={this.signOut}>Sign Out</button>
              </div>
            </>
          }
          menuClassName="user-dropdown__menu"
        />
      </div>
    );
  }
}
