import { createSignedToken, Role } from './token';
import { ExtensionManifest } from '../core/models/manifest';
import { generateId } from './id';
import { ViewerType } from '../core/models/rig';
import { ExtensionObject, ExtensionState } from 'extension-coordinator';

export function createExtensionToken(newRole: ViewerType | Role.Rig, linkedUserId: string, channelId: string, secret: string, opaqueId?: string): string {
  const opaque = opaqueId ? opaqueId : generateId(15);
  switch (newRole) {
    case ViewerType.LoggedOut:
      return createSignedToken({ role: Role.Viewer, opaqueUserId: 'ARIG' + opaque, channelId, secret });
    case ViewerType.LoggedIn:
      return createSignedToken({ role: Role.Viewer, opaqueUserId: 'URIG' + opaque, userId: linkedUserId, channelId, secret });
    case ViewerType.Broadcaster:
      return createSignedToken({ role: Role.Broadcaster, opaqueUserId: 'U' + channelId, userId: channelId, channelId, secret });
    default:
      return createSignedToken({ role: Role.Rig, opaqueUserId: 'ARIG' + opaque, channelId, secret });
  }
}

export function createExtensionObject(
  manifest: ExtensionManifest,
  index: string,
  viewerType: ViewerType,
  linkedUserId: string,
  channelId: string,
  secret: string,
  opaqueId?: string
): ExtensionObject {
  return {
    authorName: manifest.authorName,
    bitsEnabled: manifest.bitsEnabled,
    clientId: manifest.id,
    description: manifest.description,
    iconUrl: manifest.iconUrls['100x100'],
    iconUrls: {
      discoverySplash: manifest.iconUrls['300x200'],
      square24: manifest.iconUrls['24x24'],
      square100: manifest.iconUrls['100x100'],
    },
    id: `${manifest.id}:${index}`,
    name: manifest.name,
    requestIdentityLink: manifest.requestIdentityLink,
    sku: manifest.sku,
    state: manifest.state as ExtensionState,
    summary: manifest.summary,
    token: createExtensionToken(viewerType, linkedUserId, channelId, secret, opaqueId),
    vendorCode: manifest.vendorCode,
    version: manifest.version,
    viewerSummary: '',
    views: manifest.views,
    whitelistedConfigUrls: manifest.whitelistedConfigUrls,
    whitelistedPanelUrls: manifest.whitelistedPanelUrls,
  };
}
