import { GraphQLClient } from 'graphql-request'
import env from '../env';

const endpoint = 'https://gql.twitch.tv/gql';

// Global client for GraphQL access
export let graphqlClient: GraphQLClient;

export function initGraphQLClient() {
    graphqlClient = new GraphQLClient(endpoint, {
        headers: {
            'Client-Id': env.RIG_CLIENT_ID,
        },
    });
    return graphqlClient;
};
