import { RigProjectReference } from '../core/models/rig';
import { UserSession } from '../core/models/user-session';

enum LocalStorageKeys {
  CertificateExceptionScope = 'certificateExceptionScope',
  CurrentProjectIndex = 'currentProjectIndex',
  IsEphemeral = 'isEphemeral',
  IsRefreshAware = 'IsRefreshAware',
  ExtensionViewChannelId = 'extensionViewChannelId',
  ExtensionViewDisplayChannelName = 'extensionViewDisplayChannelName',
  ProjectReferences = 'projectReferences',
  RigLogin = 'rigLogin',
}

export class LocalStorage {
  public get currentProjectIndex(): number {
    return Number(localStorage.getItem(LocalStorageKeys.CurrentProjectIndex) || 0);
  }

  public set currentProjectIndex(value: number) {
    localStorage.setItem(LocalStorageKeys.CurrentProjectIndex, value.toString());
  }

  public get extensionViewChannelId(): string {
    return localStorage.getItem(LocalStorageKeys.ExtensionViewChannelId) || this.rigLogin!.id;
  }

  public set extensionViewChannelId(value: string) {
    localStorage.setItem(LocalStorageKeys.ExtensionViewChannelId, value);
  }

  public get extensionViewDisplayChannelName(): string {
    const extensionViewDisplayChannelName = localStorage.getItem(LocalStorageKeys.ExtensionViewDisplayChannelName);
    return extensionViewDisplayChannelName === null ? this.rigLogin!.login : extensionViewDisplayChannelName;
  }

  public set extensionViewDisplayChannelName(value: string) {
    localStorage.setItem(LocalStorageKeys.ExtensionViewDisplayChannelName, value);
  }

  public get isEphemeral(): boolean {
    return JSON.parse(localStorage.getItem(LocalStorageKeys.IsEphemeral) || 'false') as boolean;
  }

  public set isEphemeral(value: boolean) {
    localStorage.setItem(LocalStorageKeys.IsEphemeral, JSON.stringify(value));
  }

  public get isRefreshAware(): boolean {
    return JSON.parse(localStorage.getItem(LocalStorageKeys.IsRefreshAware) || 'false') as boolean;
  }

  public set isRefreshAware(value: boolean) {
    localStorage.setItem(LocalStorageKeys.IsRefreshAware, JSON.stringify(value));
  }

  public get projectReferences(): RigProjectReference[] {
    return JSON.parse(localStorage.getItem(LocalStorageKeys.ProjectReferences) || '[]') as RigProjectReference[];
  }

  public set projectReferences(value: RigProjectReference[]) {
    localStorage.setItem(LocalStorageKeys.ProjectReferences, JSON.stringify(value));
  }

  public get rigLogin(): UserSession | undefined {
    try {
      const userSession = (JSON.parse(localStorage.getItem(LocalStorageKeys.RigLogin) || '{}')) as UserSession;
      const { expiration = 0, authToken, id, login, profileImageUrl } = userSession;
      if (Date.now() < expiration && authToken && id && login && profileImageUrl) {
        return userSession;
      } else {
        localStorage.removeItem(LocalStorageKeys.RigLogin);
      }
    } catch (ex) {
      localStorage.removeItem(LocalStorageKeys.RigLogin);
    }
    return undefined;
  }

  public set rigLogin(value: UserSession | undefined) {
    if (value) {
      localStorage.setItem(LocalStorageKeys.RigLogin, JSON.stringify(value));
    } else {
      localStorage.removeItem(LocalStorageKeys.RigLogin);
    }
  }
}
