export interface CancelablePromise<T> {
  promise: Promise<T>,
  cancel: () => void,
}

export function makeCancelablePromise<T>(promise: Promise<T>) {
  let hasCanceled_ = false;

  const wrappedPromise = new Promise<T>((resolve, reject) => {
    promise.then(
      (val: T) => hasCanceled_ ? reject({isCanceled: true}) : resolve(val),
      (error: any) => hasCanceled_ ? reject({isCanceled: true}) : reject(error)
    );
  });

  return {
    promise: wrappedPromise,
    cancel() {
      hasCanceled_ = true;
    },
  };
};