import { ProjectUpdate } from './project-update';
import { RigProject } from '../core/models/rig';
import { CertificateException } from '../core/models/certificate-exception';

function mockApiFunctions() {
  return {
    ...require.requireActual('../util/api'),
    saveFile: jest.fn(),
  };
}
jest.mock('../util/api', () => mockApiFunctions());
const api = require.requireMock('../util/api');

describe('ProjectUpdate', () => {
  const token = 'test';
  const globalAny = global as any;

  it('constructs correctly', () => {
    const projectUpdate = new ProjectUpdate();
    const actual = projectUpdate as any;
    expect(actual.timerId).toBeDefined();
    projectUpdate.stop();
  });

  it('updates correctly', async () => {
    const projectUpdate = new ProjectUpdate();
    projectUpdate.setUpdate('filePath', { certificateExceptions: [] as CertificateException[] } as RigProject);
    await new Promise((resolve, _reject) => {
      setTimeout(resolve, 110);
    });
    expect(api.saveFile).toHaveBeenCalled();
    projectUpdate.stop();
  });
});
