import { RigProject } from '../core/models/rig';
import { saveFile } from './api';
import { CertificateException } from '../core/models/certificate-exception';

export class ProjectUpdate {
  private isSaving: boolean;
  private timerId: NodeJS.Timeout;
  private update?: { filePath: string; project: RigProject; };

  constructor() {
    this.isSaving = false;
    this.timerId = setInterval(async () => {
      const { isSaving, update } = this;
      if (!isSaving) {
        this.update = undefined;
        if (update) {
          const project = { ...update.project } as any;
          delete project.projectFolderPath;
          delete project.secret;
          project.certificateExceptions = project.certificateExceptions.filter((c: CertificateException) => !c.isEphemeral);
          this.isSaving = true;
          await saveFile(update.filePath, JSON.stringify(project, null, 2));
          this.isSaving = false;
        }
      }
    }, 55);
  }

  public setUpdate(filePath: string, project: RigProject) {
    this.update = { filePath, project };
  }

  public stop() {
    clearInterval(this.timerId);
  }
}
