import * as React from 'react';
import { CoreText, TextType, Color, Button, ButtonType, StyledLayout, Background } from 'twitch-core-ui';
import './component.sass';
import { WelcomePageSlideshow } from './components/slideshow';
import { SignInDialog } from './components/sign-in-dialog';
import { UserSession } from '../core/models/user-session';
import classNames from 'classnames';
import { sendEvent } from '../util/api';

interface Props {
  setUserSession?: (userSession: UserSession) => void;
  showCreateProjectDialog?: () => void;
}

interface State {
  showingSignIn: boolean;
}

export class WelcomePage extends React.Component<Props, State> {
  state: State = { showingSignIn: false };

  componentDidMount() {
    sendEvent('dx_rig_create_funnel_step', { step_label: this.props.setUserSession ? 'pre-sign-in' : 'post-sign-in' });
  }

  private onCallToActionClick = () => {
    const { setUserSession, showCreateProjectDialog } = this.props;
    if (setUserSession) {
      this.setState({ showingSignIn: true });
    } else if (showCreateProjectDialog) {
      showCreateProjectDialog();
    }
  }

  public render() {
    const { setUserSession } = this.props;
    const callToActionText = setUserSession ? 'Use your Twitch Credentials to Get Started' : 'Create your First Project';
    const className = classNames('welcome-page__slideshow', {
      'welcome-page__slideshow--signed-in': !setUserSession,
    });

    if (setUserSession && this.state.showingSignIn) {
      return <SignInDialog setUserSession={setUserSession} />;
    }
    return (
      <div className={className}>
        <div className="welcome-page__header">
          <div className="welcome-page__header-content">
            <CoreText bold color={Color.Overlay} type={TextType.H1}>Welcome to the Developer Rig</CoreText>
            <div>
              <Button ariaLabel={`WelcomePage:${callToActionText}`} overlay type={ButtonType.Hollow} onClick={this.onCallToActionClick}>{callToActionText}</Button>
            </div>
          </div>
        </div>
        <CoreText className="welcome-page__introduction-text">
          The Developer Rig allows you to develop and test Extensions quickly, easily, and locally.
          With the Rig, you can create Extensions for the Twitch community to enjoy.  The Rig lets
          you test how Extensions render on different channels with different settings, take
          advantage of monetization features, and maintain versions over time.
        </CoreText>
        <StyledLayout background={Background.Alt} fullWidth margin={{ top: 3 }} padding={{ top: 3 }}>
          <WelcomePageSlideshow />
        </StyledLayout>
      </div>
    );
  }
}
