import { setupShallowTest } from '../../../tests/enzyme-util/shallow';
import { SignInDialog } from './component';
import electron from '../../../electron';
import { timeout } from '../../../tests/utils';

let token: string;

function mockApiFunctions() {
  return {
    ...require.requireActual('../../../util/api'),
    fetchAuth: jest.fn(() => Promise.resolve(token === 'none' ? '' : token === 'invalid' ? 'access_token=x&access_token=y' : `access_token=${token}`)),
    fetchUser: jest.fn((name) => name === 'resolve' ? Promise.resolve({ id: 'id' }) : Promise.reject(new Error(name))),
    showMessageBox: jest.fn(),
  };
}
jest.mock('../../../util/api', () => mockApiFunctions());
const api = require.requireMock('../../../util/api');

describe('<SignInDialog />', () => {
  const setUserSession = jest.fn();
  const setupShallow = setupShallowTest(SignInDialog, () => ({ setUserSession }));

  it('renders correctly', async () => {
    token = 'resolve';
    const { wrapper } = setupShallow();
    expect(wrapper.debug()).toMatchSnapshot();
    await timeout();
    expect(api.fetchAuth).toHaveBeenCalled();
    expect(api.fetchUser).toHaveBeenCalled();
    expect(setUserSession).toHaveBeenCalled();
  });

  it('shows error on missing token', async () => {
    token = 'none';
    setupShallow();
    await timeout();
    expect(api.fetchAuth).toHaveBeenCalled();
    expect(api.fetchUser).toHaveBeenCalled();
    expect(api.showMessageBox).toHaveBeenCalledWith({ title: 'Sign-in Error', message: 'no access token', type: 'error' });
  });

  it('shows error on invalid token', async () => {
    token = 'invalid';
    setupShallow();
    await timeout();
    expect(api.fetchAuth).toHaveBeenCalled();
    expect(api.fetchUser).toHaveBeenCalled();
    expect(api.showMessageBox).toHaveBeenCalledWith({ title: 'Sign-in Error', message: 'invalid access token', type: 'error' });
  });

  it('shows error on failed user fetch', async () => {
    token = 'reject';
    setupShallow();
    await timeout();
    expect(api.fetchAuth).toHaveBeenCalled();
    expect(api.fetchUser).toHaveBeenCalled();
    expect(api.showMessageBox).toHaveBeenCalledWith({ title: 'Sign-in Error', message: token, type: 'error' });
  });

  it('sets webview', () => {
    token = 'resolve';
    const { wrapper } = setupShallow();
    const instance = wrapper.instance() as any;
    let newWindow = (_: any) => { };
    const webview = {
      addEventListener: jest.fn((_name, fn) => {
        newWindow = fn;
      }),
    };
    instance.setWebview(webview);
    expect(webview.addEventListener).toHaveBeenCalled();
    newWindow({ url: 'http://test' });
    expect(electron.openExternal).toHaveBeenCalled();
  });
});
