import * as React from 'react';
import { Layout, Display, FlexDirection, AlignItems, TextAlign, CoreText, TextType, SVGAsset, ButtonIcon, Position, ButtonIconType, CoreImage } from 'twitch-core-ui';
import screenshot1 from '../../../img/welcome-page-slideshow__screenshot1.png';
import screenshot2 from '../../../img/welcome-page-slideshow__screenshot2.png';
import screenshot3 from '../../../img/welcome-page-slideshow__screenshot3.png';
import './component.sass';
import classNames from 'classnames';

const slides = [{
  header: 'Begin Your Extensions Journey in Minutes',
  paragraph: 'Find full samples and boilerplate code to begin your Extension with the push of a couple buttons, so you’re not starting from scratch. Step-by-step tutorials also help you through the entire development process.',
  screenshot: screenshot1,
}, {
  header: 'Easily Manage Your Extensions Projects',
  paragraph: 'Build and manage all your Extensions projects in one place with tools like Configuration Service, which removes the burden of writing a back end to store persistent channel- and Extension-specific data, manage Bits monetization options, and maintain version control.',
  screenshot: screenshot2,
}, {
  header: 'Quickly and Thoroughly Test Your Extensions',
  paragraph: 'Easily test against different views, user roles, and configurations. You can even compare view ports side by side to test shared experiences. The Developer Rig lets you test your Extensions responsive design when streamers customize the Extension’s configuration settings like switching light and dark themes and using localization.',
  screenshot: screenshot3,
}];

interface State {
  slideIndex: number;
}

export class WelcomePageSlideshow extends React.Component<{}, State> {
  public state: State = {
    slideIndex: 0,
  };
  public render() {
    const { slideIndex } = this.state;
    return (
      <Layout
        alignItems={AlignItems.Center}
        display={Display.Flex}
        flexDirection={FlexDirection.Column}
        textAlign={TextAlign.Center}
      >
        <CoreText className="welcome-page-slideshow__header" type={TextType.H3}>
          {slides[slideIndex].header}
        </CoreText>
        <Layout padding={{ top: 4 }} position={Position.Relative}>
          {slideIndex > 0 && (
            <Layout className="welcome-page-slideshow__nav-icon welcome-page-slideshow__nav-icon--left">
              <ButtonIcon
                ariaLabel="Previous tip"
                icon={SVGAsset.AngleLeft}
                onClick={this.onPrevSlideClick}
                type={ButtonIconType.Secondary}
              />
            </Layout>
          )}
          <CoreText className="welcome-page-slideshow__paragraph">
            {slides[slideIndex].paragraph}
          </CoreText>
          {(slideIndex < slides.length - 1) && (
            <Layout className="welcome-page-slideshow__nav-icon welcome-page-slideshow__nav-icon--right">
              <ButtonIcon
                ariaLabel="Next tip"
                icon={SVGAsset.AngleRight}
                onClick={this.onNextSlideClick}
                type={ButtonIconType.Secondary}
              />
            </Layout>
          )}
        </Layout>
        <Layout padding={{ top: 5 }}>
          <svg className="welcome-page-slideshow__svg" width="60" height="10" viewBox="0 0 60 10" xmlns="http://www.w3.org/2000/svg">
            {[0, 1, 2].map((n) => {
              const circleClassName = classNames({
                'welcome-page-slideshow__active': slideIndex === n,
              });
              return (
                <circle className={circleClassName} key={n} cx={5 + n * 25} cy="5" r="5" />
              );
            })}
          </svg>
        </Layout>
        <Layout padding={{ top: 4 }}>
          <CoreImage alt="Project details screenshot" src={slides[slideIndex].screenshot} />
        </Layout>
      </Layout>
    );
  }

  private onNextSlideClick = () => {
    this.navigateSlides(1);
  }

  private onPrevSlideClick = () => {
    this.navigateSlides(-1);
  }

  private navigateSlides(deltaFromCurrentIndex: number) {
    this.setState((prevState) => {
      const slideIndex = prevState.slideIndex + deltaFromCurrentIndex;
      if (slideIndex < slides.length && slideIndex >= 0) {
        return {
          slideIndex,
        };
      } else {
        return null;
      }
    })
  }
}
