# E2 Docs

---

- [Getting Started](#getting-started)
  - [Running Docs Locally](#running-docs-locally)
  - [Structure](#structure)
- [Structure & Conventions](#structure-conventions)
  - [Page Title & Path](#page-title-path)
  - [Changing the Order of Pages in the Navigation](#changing-the-order-of-pages-in-the-navigation)
  - [Page Tabs](#page-tabs)
  - [Redirects](#redirects)
- [Markdown](#markdown)
- [Code Blocks & Previews](#code-blocks--previews)
- [Custom Markdown Blocks](#custom-markdown-blocks)
  - [Links](#links)
  - [Columns](#columns)
  - [Guidelines](#guidelines)
- [Images and static assets](#images-and-static-assets)
- [Building site](#building)

## Getting Started

### Running Docs Locally

To run the docs site locally with complete data, you must:

1. Be on the VPN
2. [Install Git LFS](https://git-lfs.github.com/)
3. Set up a [GitHub Personal Access Token](#gitHub-personal-access-token)

After this setup, clone the repo and run `yarn install`.

If you want a development version of the site, run `yarn start`, which will spin up a Gatsby development server on localhost:8090

If you want a static production version of the site, run `yarn build`, which will compile the pages and store them in /public/


### Structure

```
.
├── /data                            // documentation markdown
├── /src                             // source code
│   ├── /components                  // reusable components (e.g. header, authenticate callout, search bar)
│   ├── /layouts                     // gatsby layouts (which gatsby combines with markdown to generate pages)
│   ├── /pages                       // gastby pages defined in jsx (homepage, 404 page)
│   ├── /scss                        // documentation scss
│   ├── /templates                   // gatsby page templates
│   ├── /utils                       // documentation utilities (path helper, render link)
│   ├── declarations.ts              // module declarations
│   └── graphql-types.d.ts           // type definitions for graphql objects
├── .editorconfig                    // shared VSCode configuration
├── .env                             // (unversioned) for github api call (when creating changelog)
├── gatsby-browser.js                // see https://www.gatsbyjs.org/docs/browser-apis/
├── gatsby-config.js                 // gatsby (documentation) config
├── gatsby-node.js                   // documentation content bootstrapping
├── gatsby-ssr.js                    // gatsby ssr file
├── html.tsx                         // gatsby (documentation) html scaffolding
├── package.json                     //
├── settings.js                      // documentation settings
├── tsconfig.json                    // typescript config
├── tslint.json                      // typescript linting config
└── yarn.lock                        //
```

---

e2-docs is a static website built on [GatsbyJS](https://www.gatsbyjs.org/)

## Structure and Conventions

All of the content for the site is made up of markdown files located in `/data`. Every directory must contain an `index.md` file for it to be generated into a page. If the page simply redirects to a child page, see [#Redirects].

```
.
├── /data
    └── /1-enhanced-experiences
        ├── /1-introduction       
        │   └── index.md
        └── /2-guide-and-api-reference
            └── /1-guide
                └── /1-guide-a
                    └── index.md
                └── /2-guide-b
                    └── index.md
```

### Page Title and Path

The page title and path are generated automatically by the directory structure: the `index.md` file in the `/1-introduction` directory will create a page with the title `Introduction` located at `/enhanced-experiences/introduction`.

The page title can be overwritten by adding a `title` key in the frontmatter of the page's `index.md` file, ie:

```
# 1-enhanced-experiences/1-introduction/index.md

---
title: Getting started
---
```

### Changing the Order of Pages in the Navigation

By default, the site navigation will list pages alphabetically; but, the ordering can be overwritten by prefixing directory names with a number (ie. `/components` to `/3-components`). **These numbers are stripped from the URL pathname.**

### Page Tabs

Additional tabs can be added to a page, but requires knowledge of gatsby page creation. As an example, you may look at [core-ui-docs](https://git.xarth.tv/core-ui/core-ui-docs/blob/master/gatsby-node.js#L214)'s page creation,


1) Make a new jsx template in `/src/templates`, the graphql query at the bottom of the page is compile-time data
2) In gatsby-node.js, in the exports.createPages stage, add the filename of the template to the `templateNames` variable
3) In gatsby-node.js, in the exports.createPages stage, 


```
Note: page settings are only read from the frontmatter in the index.md of the same directory.
```

### Redirects

Pages can redirect to a child page. This can be done by setting the `redirect` key in the `index.md` file.

```
# 1-enhanced-experiences/index.md

redirect: introduction
```

This example will redirect the `/enhanced-experiences` page to `/enhanced-experiences/introduction`.

## Markdown

Markdown is a simple way of writing content that can be converted into HTML markup. Becaue our titles are automatically generated, there is no need to write a title (`#` or `h1`) inside the markdown content.

```
## Heading 2
### Heading 3
#### Heading 4
```

Read more from the Markdown [cheat sheet](https://www.markdownguide.org/cheat-sheet/).

## Code Blocks

The language of the code block can be set to display syntax highlighting (currently code-js, code-json, and code-go are supported)


````
```code-go
func main() {
  return 0
}
```
````

## JSX Rendering
For `jsx` snippets, the code is rendered in a preview

````
```jsx
<Button />
```
````

Additional classes can be added to the code block to customize the display of the editor and preview. Twitch core-ui components will be auto imported.


<br />

## Custom Markdown Blocks

These blocks create a richer formatting for markdown editing. They allow us to specify data to be rendered in components within the markdown – such as resource links, columns, and guidelines. The data is accepted in `yaml` format and can be implemented through a code block, e.g.:

````
```yml-block-columns
````

### Links

Render 1-2 resource link tiles.

![](/assets/images/markdown-block-link.png)

````
```yml-block-links
-
  title: Logo Assets
  body: PNG and SVG versions of the Twitch logo, Glitch logo, and combination logo.
  url: /assets/downloads/Twitch-Logos.zip
  thumbnailSrc: /assets/brand/images/Twitch-Logos-Download-Preview.png
  download: true
```
````

| Key            | Type      | Description                               |
| -------------- | --------- | ----------------------------------------- |
| `title`        | `string`  | The title of the link.                    |
| `body`         | `string`  | Description text.                         |
| `buttonLabel`  | `string`  | Customize the button label text.          |
| `url`          | `string`  | Destination/source of the link.           |
| `thumbnailSrc` | `string`  | Source for the thumbnail image.           |
| `download`     | `boolean` | Add the `download` attribute to the link. |
| `targetBlank`  | `boolean` | Open the link in a new browser tab.       |

<br />

### Columns

Render multiple columns of markdown content.

![](/assets/images/markdown-block-columns.png)

````
```yml-block-columns
-
  cols: 4
  body: |
    ![Twitch Logo](/assets/brand/images/Combo---Logotype-16x9.png)
-
  cols: 4
  body: |
    ![Twitch Logo](/assets/brand/images/Glitch---Brand-Mark-16x9.png)
-
  cols: 4
  body: |
    ![Twitch Logo](/assets/brand/images/Twitch---Logotype-16x9.png)
```
````

| Key    | Type     | Description                |
| ------ | -------- | -------------------------- |
| `cols` | `number` | Number of columns to span. |
| `body` | `string` | Markdown content.          |

<br />

### Guidelines

Render 1-2 guideline blocks with images and markdown content.

![](/assets/images/markdown-block-guidelines.png)

````
```yml-block-guidelines
-
  type: 'do'
  mediaSrc: '/assets/brand/images/Combo---Application---Color-and-Contrast---Dark-4x3.png'
-
  type: 'dont'
  mediaSrc: '/assets/brand/images/Combo---Application---Color-and-Contrast---Background-4x3.png'
```
````

| Key        | Type         | Description                            |
| ---------- | ------------ | -------------------------------------- |
| `type`     | `do`, `dont` | Render as a ✅ or 🚫 guidelines.       |
| `mediaSrc` | `string`     | The source of the main image or video. |
| `caption`  | `string`     | A caption to display below the media.  |
| `body`     | `string`     | Markdown content.                      |

<br />

### Media

Renders some media with a frame, drop shadow, and optional caption.

````
```yml-block-media
mediaSrc: 'https://www.twitch.tv/example.jpg'
caption: 'Hello World!'
```
````

| Key        | Type     | Description                            |
| ---------- | -------- | -------------------------------------- |
| `mediaSrc` | `string` | The source of the main image or video. |
| `caption`  | `string` | A caption to display below the media.  |

---

<br>

## Images and static assets

### Setup

You must install [Git LFS](https://git-lfs.github.com/) before adding or changing static assets.

0. [Install Homebrew](https://brew.sh/) if you don't have it.
1. `brew install git-lfs`
1. `git lfs install`
1. `git checkout master` + `git pull`

### How to add files

In the repository, add your files in the folder: /static/assets/

Use them in Markdown like this:

```
![A picture of the Enhanced Experience Icon](/assets/E2Small.png)
```

Or in html like this:

```
<img src=”/assets/images/avatars/BobRoss.jpg” alt=”A picture of Bob Ross” />
```

For non-markdown content, consider [importing assets directly](https://www.gatsbyjs.org/docs/importing-assets-into-files/).

Use your regular workflow to commit and push the asset and open a PR. The asset is automatically uploaded to git-lfs and included in your PR.

## Building

#### VPN

You must be on the twitch vpn in order to run `yarn build` otherwise the build process will not be able to fetch github release data


#### GitHub Personal Access Token

We access the GitHub API to pull data like the commit history for components and user avatars. In order to access the API, you have to obtain and set a GitHub Personal Access Token as an environment variable.

To obtain a token, visit [https://git.xarth.justin.tv/settings/tokens](https://git.xarth.tv/settings/tokens) and click `Generate New Token`. Add a description for the token, check `repo` under "Select scopes" and click `Generate Token`.

Copy the token and paste it in a file called `.env` in the project root, ie:

```
GITHUB_ACCESS_TOKEN=generated_access_token
```
