/* eslint-disable */
import * as React from "react";
import { SiteLayout } from "./src/components/layout";
import { constructReporter, reportPageview } from "./src/utils/analytics";

export const wrapPageElement = ({ element, props }) => {
  return <SiteLayout {...props}>{element}</SiteLayout>;
};

export const onClientEntry = () => {
  if (typeof window === undefined) {
    console.error("Cannot initialize tracker");
    return;
  }
  constructReporter().then(reporter => {
    window.spadeReporter = reporter;
  });
};

export const onRouteUpdate = ({ location, prevLocation }) => {
  reportPageview({ properties: { location: location.pathname } });
};

export { wrapRootElement } from "./src/apollo/wrap-root-element";

