/**
 * Gatsby Configuration
 */

require("dotenv").config();

const pathPrefix = process.env.GATSBY_PATH_PREFIX;
const pluginPath = `${__dirname}/compiled/plugins`;

module.exports = {
  pathPrefix,
  siteMetadata: {
    title: `Twitch Core Design System`,
  },
  plugins: [
    // Custom source plugin that fetches GitHub data for version releases.
    {
      resolve: `${pluginPath}/gatsby-source-github-enterprise/gatsby-node.js`,
      options: {
        user: `devhub`,
        repository: `e2-docs`,
        token: process.env.GITHUB_ACCESS_TOKEN || ``,
        rootURL: `https://git.xarth.tv/api/v3`,
        baseDir: __dirname,
      },
    },

    // Custom source plugin that gets version information
    {
      resolve: `${pluginPath}/gatsby-version-data/gatsby-node.js`,
    },

    // Source the files needed to build the site. This includes all of the
    // markdown files from `data`.
    {
      resolve: `gatsby-source-filesystem`,
      options: {
        path: `${__dirname}/data`,
      },
    },
    {
      resolve: "gatsby-source-filesystem",
      options: {
        path: `${__dirname}/static`,
      },
    },
    // Parse all markdown files (each plugin add/parse some data into
    // graphQL layer).
    {
      resolve: `gatsby-transformer-remark`,
      options: {
        plugins: [
          {
            resolve: `gatsby-remark-images`,
            options: {
              maxWidth: 900,
              backgroundColor: `#f7f0eb`,
            },
          },
          `gatsby-remark-emoji`,
          `gatsby-remark-copy-linked-files`,
          `gatsby-remark-autolink-headers`,
          // Note: The following plugin is a temporary solution to an issue with
          // `gatsby-transformer-remark` where images are not being prefixed with
          // the Gatsby`pathPrefix`.
          //
          // We have submitted a PR to `gatsby` to fix this issue in the plugin:
          // https://github.com/gatsbyjs/gatsby/pull/21434
          {
            resolve: `${pluginPath}/gatsby-remark-prefix-assets/index.js`,
          },
        ],
      },
    },

    // SASS
    {
      resolve: `gatsby-plugin-sass`,
      options: {
        includePaths: [
          "node_modules/twitch-core-ui/",
          "node_modules/",
          `${__dirname}/src/scss`,
        ],
        sourceMaps: true,
      },
    },

    // PostCSS
    {
      resolve: `gatsby-plugin-postcss`,
      options: {
        postCssPlugins: [
          require("autoprefixer")({
            remove: false,
          }),
        ],
      },
    },

    // styled-components
    {
      resolve: `gatsby-plugin-styled-components`,
      options: {
        fileName: false,
        pure: true,
      },
    },

    // Typescript Support (via ts-loader)
    `gatsby-plugin-typescript`,

    // Parse JSON files
    `gatsby-transformer-json`,
  ],
};
