#!/usr/bin/env node
import * as cdk from "@aws-cdk/core";
import "source-map-support/register";
import { CloudfrontStack } from "../lib/cloudfront-stack";
import { VPCStack } from "../lib/vpc-stack";
import { OsirisCloudformationStack } from "../lib/osiris-stack";
import { AuthLambdaEdgeStack } from "../lib/lambda-stack";
import { StaticWebpagesS3BucketStack } from "../lib/s3-stack";
import {
  DEV_ACCOUNT_ID,
  DEV_PREFIX,
  PROD_ACCOUNT_ID,
  PROD_PREFIX,
  REGION,
  WEBSITE_NAME,
} from "./consts";

const app = new cdk.App();

const devProps = {
  env: { account: DEV_ACCOUNT_ID, region: REGION },
  prefix: DEV_PREFIX,
};

const prodProps = {
  env: { account: PROD_ACCOUNT_ID, region: REGION },
  prefix: PROD_PREFIX,
};

export const createStack = (
  scope: cdk.App,
  props: { env: cdk.Environment; prefix: string },
) => {
  const { env, prefix } = props;

  const staticWebpagesS3BucketStack = new StaticWebpagesS3BucketStack(
    scope,
    `${prefix}-StaticWebpagesS3BucketStack`,
    {
      env,
      prefix,
    },
  );

  const authLambdaStack = new AuthLambdaEdgeStack(
    scope,
    `${prefix}-AuthLambdaEdgeStack`,
    {
      env,
      prefix,
    },
  );
  const cloudfrontStack = new CloudfrontStack(
    scope,
    `${prefix}-CloudfrontStack`,
    {
      env,
      siteBucket: staticWebpagesS3BucketStack.bucket,
      prefix,
      handlerVersion: authLambdaStack.handlerVersion,
      originAccessIdentity: staticWebpagesS3BucketStack.originAccessIdentity,
    },
  );
};

const deployOsiris = (
  scope: cdk.App,
  props: { env: cdk.Environment; prefix: string },
) => {
  const { env, prefix } = props;
  
  const osirisCloudformationStack = new OsirisCloudformationStack(
    scope,
    `${prefix}-OsirisCloudformationStack`,
    {},
  );
};
deployOsiris(app, devProps);
app.synth();
