import * as cloudfront from "@aws-cdk/aws-cloudfront";
import * as iam from "@aws-cdk/aws-iam";
import * as lambda from "@aws-cdk/aws-lambda";
import * as s3 from "@aws-cdk/aws-s3";
import * as cdk from "@aws-cdk/core";
import { Stack, StackProps } from "@aws-cdk/core";
import { WEBSITE_NAME } from "../bin/consts";
import { CommonProps } from "./commonProps";

export interface CloudfrontStackProps extends CommonProps {
  siteBucket: s3.Bucket;
  originAccessIdentity: cloudfront.IOriginAccessIdentity;
  handlerVersion: lambda.IVersion;
}

export class CloudfrontStack extends Stack {
  public readonly cloudfrontDistribution: cloudfront.CloudFrontWebDistribution;

  constructor(scope: cdk.Construct, id: string, props: CloudfrontStackProps) {
    super(scope, id, props);
    const { siteBucket, handlerVersion, originAccessIdentity, prefix } = props;
    const name = `${prefix}-${WEBSITE_NAME}`;

    this.cloudfrontDistribution = new cloudfront.CloudFrontWebDistribution(
      this,
      `${name}-cloudfront-distribution`,
      {
        originConfigs: [
          {
            s3OriginSource: {
              s3BucketSource: siteBucket,
              originAccessIdentity,
            },
            behaviors: [
              {
                isDefaultBehavior: true,
                lambdaFunctionAssociations: [
                  {
                    eventType: cloudfront.LambdaEdgeEventType.ORIGIN_REQUEST,
                    lambdaFunction: handlerVersion,
                  },
                ],
              },
            ],
          },
        ],
      },
    );
  }
}
