import * as cloudformation from "@aws-cdk/aws-cloudformation";
import * as cdk from "@aws-cdk/core";
import {
  OSIRIS_CFN_TEMPLATE,
  OSIRIS_ENVIRONMENT,
  OSIRIS_SERVICE_NAME,
  SANDSTORM_PREFIX,
  SANDSTORM_ROLE,
  TEAM_EMAIL,
  TEAM_NAME,
} from "../bin/consts";

import * as ec2 from "@aws-cdk/aws-ec2";
import { CommonProps } from "./commonProps";

export interface OsirisCloudformationProps extends CommonProps {
  vpc: ec2.Vpc;
}

export class OsirisCloudformationStack extends cdk.Stack {
  constructor(
    scope: cdk.Construct,
    id: string,
    props: OsirisCloudformationProps,
  ) {
    super(scope, id, props);

    const { prefix, vpc } = props;

    const osirisStack = new cloudformation.CfnStack(this, `${prefix}-osiris`, {
      templateUrl: OSIRIS_CFN_TEMPLATE,
      parameters: {
        ServiceName: OSIRIS_SERVICE_NAME,
        Environment: OSIRIS_ENVIRONMENT,
        TeamName: TEAM_NAME,
        TeamEmail: TEAM_EMAIL,
        AlertsEnabled: "enabled",
        SandstormRole: SANDSTORM_ROLE,
        SandstormPrefix: SANDSTORM_PREFIX,
        PublicSubnets: vpc.publicSubnets.join(", "),
        PrivateSubnets: vpc.privateSubnets.join(", "),
        Vpc: vpc.vpcId,
        // TODO: after https://jira.twitch.com/browse/TWIT-3955
        PingIntegrationName: "",
        // Optional/defaults
        PagerDutyIntegrationUrl: "",
        InternalFQDN: "",
        AdditionalDomains: "",
      },
    });
  }
}
