import * as ec2 from "@aws-cdk/aws-ec2";
import * as cdk from "@aws-cdk/core";
import { GHE_ENDPOINT_VPC_REGION, WEBSITE_NAME } from "../bin/consts";
import { CommonProps } from "./commonProps";

export interface OsirisVPCStackProps extends CommonProps {}

export class OsirisVPCStack extends cdk.Stack {
  public osirisVPC: ec2.IVpc;
  constructor(scope: cdk.Construct, id: string, props: OsirisVPCStackProps) {
    super(scope, id, props);

    const { prefix } = props;

    this.osirisVPC = new ec2.Vpc(this, `${prefix}-${WEBSITE_NAME}-vpc`, {});
  }
}
