import * as cloudfront from "@aws-cdk/aws-cloudfront";
import * as iam from "@aws-cdk/aws-iam";
import * as s3 from "@aws-cdk/aws-s3";
import * as cdk from "@aws-cdk/core";
import { Stack } from "@aws-cdk/core";
import { WEBSITE_NAME } from "../bin/consts";
import { CommonProps } from "./commonProps";

export interface StaticWebpagesS3BucketStackProps extends CommonProps {}

export class StaticWebpagesS3BucketStack extends Stack {
  public readonly bucket: s3.Bucket;
  public readonly originAccessIdentity: cloudfront.OriginAccessIdentity;

  constructor(
    scope: cdk.Construct,
    id: string,
    props: StaticWebpagesS3BucketStackProps,
  ) {
    super(scope, id, props);
    const { prefix } = props;
    const name = `${prefix}-${WEBSITE_NAME}`;

    this.bucket = new s3.Bucket(this, name, {
      bucketName: name,
      publicReadAccess: false,
      removalPolicy: cdk.RemovalPolicy.DESTROY,
    });

    const s3AccessPolicy = new iam.PolicyStatement({
      actions: ["s3:GetObject*", "s3:GetBucket*", "s3:List*"],
      resources: [this.bucket.bucketArn, `${this.bucket.bucketArn}/*`],
    });

    this.originAccessIdentity = new cloudfront.OriginAccessIdentity(
      this,
      "OAI",
      {
        comment: `${name}-website-OAI`,
      },
    );

    s3AccessPolicy.addPrincipals(this.originAccessIdentity.grantPrincipal);
  }
}
