import {
  expect as expectCDK,
  MatchStyle,
  matchTemplate,
} from "@aws-cdk/assert";
import * as cdk from "@aws-cdk/core";
import * as Infrastructure from "../lib/infrastructure-stack";

const testProps = {
  env: { account: "0", region: "us-east-1" },
  websiteName: "infrastructure-test",
  prefix: "test",
};

test("Empty Stack", () => {
  const app = new cdk.App();
  // WHEN
  const stack = new Infrastructure.StaticSiteStack(
    app,
    "MyTestStack",
    testProps,
  );
  // THEN
  expectCDK(stack).to(
    matchTemplate(
      {
        Resources: {},
      },
      MatchStyle.EXACT,
    ),
  );
});
