const fs = require("fs-extra");
const path = require("path");
const glob = require("glob");

const projectBaseDir = path.resolve(__dirname, "..");

fs.removeSync(`${projectBaseDir}/compiled`);

const matches = glob.sync("src/plugins/**/package.json", {
  cwd: projectBaseDir,
});

if (matches && matches.length > 0) {
  matches.forEach(sourceFile => {
    const destFile = sourceFile.replace("src/", "compiled/");
    fs.copy(sourceFile, destFile);
  });
}
