# Core Design System Documentation Framework

## Frontmatter

- [Component](#component)
- [Redirect](#redirect)
- [Title](#title)

---

### Component (`object`)

Specifies a component to associate with the page. Keys:

- **`id`** (`string`) – Identifier for the component, ie `components/form/checkbox`.
- `disablePlayground` (`boolean`) – Disable the playground for this component page. Default `false`.

#### Examples

Basic:

```
---
component:
  id: components/avatar
---
```

Playground Disabled:

```
---
component:
  id: components/layout
  disablePlayground: true
---
```

---

### Redirect (`string`)

Allows pages to redirect to a child page.

### Examples

`2-user-interface/index.md`:

```
---
redirect: guidelines/getting-started
---
```

`2-user-interface/components/form/index.md`:

```
---
redirect: checkboc
---
```

---

### Title (`string`)

Customize the title of the page.
