import ApolloClient from "apollo-boost";
import fetch from "cross-fetch";
import * as Cookies from "js-cookie";

export const client = new ApolloClient({
  fetch,
  uri: "https://gql.twitch.tv/gql",
  request: operation => {
    const token = Cookies.get("auth-token");
    operation.setContext({
      headers: {
        authorization: token ? `OAuth ${token}` : "",
      },
    });
  },
});
