import { useQuery } from "@apollo/react-hooks";
import gql from "graphql-tag";

import * as _ from "lodash";
import * as React from "react";
import { InFeatureNotification, NotificationType } from "twitch-core-ui";

const GET_ORGS = gql`
  {
    currentUser {
      organizations {
        games {
          enhancedExperiencesClients {
            id
          }
        }
      }
    }
  }
`;

export const AuthenticateCallout = () => {
  const [isClosed, setClosed] = React.useState(false);
  const { data, loading, error } = useQuery(GET_ORGS, {
    ssr: false,
  });

  const games = _.flatten(data?.currentUser?.organizations || []);
  const clients = _.flatten(games || []);

  if (isClosed || loading || error || clients.length > 0) {
    return null;
  }

  return (
    <InFeatureNotification
      type={NotificationType.Warning}
      message={{
        title: "Authenticate Client ID",
        description:
          "Contact your solution architect to get your client ID authenticated and make use of all the information provided here.",
      }}
      closeButton={{
        ariaLabel: "Close Modal",
        onClick: () => setClosed(true),
      }}
      actions={{
        primaryButton: { children: "Contact SA" },
        secondaryButton: { children: "Learn More" },
      }}
    />
  );
};
