import * as React from "react";
import {
  Color,
  CoreText,
  InjectLayout,
  StyledLayout,
  TextAlign,
} from "twitch-core-ui";

export interface CaptionProps {
  label: string;
  children?: React.ReactNode;
}

export function Caption(props: CaptionProps) {
  return (
    <InjectLayout fullWidth>
      <figcaption>
        {props.children}
        <StyledLayout textAlign={TextAlign.Right} padding={1}>
          <CoreText color={Color.Alt2}>{props.label}</CoreText>
        </StyledLayout>
      </figcaption>
    </InjectLayout>
  );
}
