import * as classnames from "classnames";
import * as React from "react";

import { LiveError, LivePreview, LiveProvider } from "react-live";
import {
  BorderRadius,
  Color,
  Display,
  InjectStyledLayout,
  Layout,
} from "twitch-core-ui";
import * as core from "twitch-core-ui";
import "./styles.scss";

interface Props {
  calculateWidth?: boolean;
  centerContent?: boolean;
  children?: React.ReactNode;
  renderCode: string;
  showOverlay?: boolean;
  refDelegate?: (e: HTMLDivElement) => void;
  width?: number;
}

export class CodePreview extends React.Component<Props> {
  public render() {
    const classes: ClassValue = {
      "code-preview": true,
      "code-preview--show-overlay": this.props.showOverlay,
      "code-preview--center-content": this.props.centerContent,
    };

    let layoutProps;

    // The content needs to load at its original size in order to get the
    // correct informatino to calculate its aspect ratio. If don't set a
    // calculated width, set fullHeight and fullWidth on the preview.
    if (!this.props.calculateWidth) {
      layoutProps = {
        fullWidth: true,
        fullHeight: true,
      };
    }

    return (
      <InjectStyledLayout
        className={classnames(classes)}
        borderRadius={BorderRadius.Medium}
        color={Color.Base}
        display={Display.Block}
        {...layoutProps}
      >
        <div
          ref={this.props.refDelegate}
          style={{
            width: this.props.width,
            margin: this.props.width && "auto",
          }}
        >
          <LiveProvider code={`<>${this.props.renderCode}</>`} scope={core}>
            <LiveError />
            <LivePreview />
          </LiveProvider>

          {this.props.children && (
            <Layout padding={{ top: 2 }} fullWidth>
              {this.props.children}
            </Layout>
          )}
        </div>
      </InjectStyledLayout>
    );
  }
}
