import * as React from "react";
import {
  Background,
  BorderRadius,
  Display,
  StyledLayout,
} from "twitch-core-ui";

interface Props {
  className?: string;
  property: keyof CSSStyleDeclaration;
  showPropName?: boolean;
}

interface State {
  computedStyles?: CSSStyleDeclaration;
}

/**
 * Displays the computed value for a given CSS property and classname
 */
export class CSSValueDisplay extends React.PureComponent<Props, State> {
  public state: State = {
    computedStyles: undefined,
  };

  public render() {
    let value = "";

    if (this.state.computedStyles) {
      value = this.state.computedStyles[this.props.property];
    }

    return (
      <div className={this.props.className} ref={this.setRef}>
        <StyledLayout
          display={Display.InlineBlock}
          padding={{ x: 0.5 }}
          background={Background.Alt}
          border
          borderRadius={BorderRadius.Small}
        >
          {this.props.showPropName && `${this.props.property}: `}
          {value}
        </StyledLayout>
      </div>
    );
  }

  private setRef = (e: HTMLDivElement) => {
    this.setState({
      computedStyles: e ? window.getComputedStyle(e) : undefined,
    });
  };
}
