import { LocationContext } from "@reach/router";
import { graphql, Link, StaticQuery } from "gatsby";
import * as React from "react";
import {
  AlignItems,
  Background,
  Display,
  FontSize,
  Icon,
  Layout,
  Position,
  StyledLayout,
  SVG,
  SVGAsset,
} from "twitch-core-ui";

import { Search } from "../search/search/component";
import { dataToSearchObjects } from "../search/utils/search-utils";
import { ThemeSwitcher } from "../theme-switcher";
import "./styles.scss";

interface Props extends LocationContext {}

interface State {
  showSupportMenu: boolean;
  searchIsFocused: boolean;
  query: string;
}

export class Header extends React.Component<Props, State> {
  constructor(props: Props) {
    super(props);

    this.state = {
      showSupportMenu: false,
      searchIsFocused: false,
      query: "",
    };
  }

  public render() {
    return (
      <StaticQuery
        query={graphql`
          query SearchQuery {
            allPages: allSitePage {
              ...SearchPagesFragment
            }
            allFiles: allFile {
              ...SearchFilesFragment
            }
            projectVersions: consumerProjectVersionsFile {
              id
              currentProjectVersion
            }
          }
        `}
        render={data => (
          <StyledLayout
            className="header"
            display={Display.Flex}
            position={Position.Fixed}
            background={Background.Base}
            padding={{ x: 1, y: 0.5 }}
            fontSize={FontSize.Size5}
            elevation={1}
            fullWidth
          >
            <Layout
              display={Display.Flex}
              alignItems={AlignItems.Center}
              flexGrow={1}
            >
              <Layout margin={{ top: 2, left: 1, bottom: 1 }}>
                <Link to="/">
                  <SVG
                    height={48}
                    width={73}
                    asset={SVGAsset.LogoTwitchDevelopers}
                  />
                </Link>
              </Layout>
            </Layout>
            <Layout display={Display.Flex} alignItems={AlignItems.Center}>
              <Search
                items={dataToSearchObjects(data.allPages, data.allFiles)}
                location={this.props.location}
                navigate={this.props.navigate}
              />
              <Layout display={Display.Flex} padding={{ left: 2, right: 1 }}>
                <Link to="change-log">
                  <Icon asset={SVGAsset.QuestionMark} />
                </Link>
              </Layout>
              <Layout display={Display.Flex} padding={{ x: 1 }}>
                <ThemeSwitcher />
              </Layout>
            </Layout>
          </StyledLayout>
        )}
      />
    );
  }
}
