import { fileAccessibility } from "../../tests/data/file__accessibility";
import { fileGettingStarted } from "../../tests/data/file__getting-started";
import { fileTransitionGroup } from "../../tests/data/file__transition-group";
import { fileWritingForProducts } from "../../tests/data/file__writing-for-products";
import { setupShallowTest } from "../../tests/helpers";
import { Markdown, Props } from "./component";

const defaultProps: Props = {
  source: "",
};

const setupShallow = setupShallowTest(Markdown, () => defaultProps);

describe("Markdown component", () => {
  it("renders a simple h1 tag", () => {
    const { wrapper } = setupShallow({
      source: "<h1>Hello World</h1>",
    });
    expect(wrapper).toMatchSnapshot();
  });

  it("snapshot of Getting Started page", () => {
    const { wrapper } = setupShallow({
      source: fileGettingStarted.data.file.childMarkdownRemark.html,
    });
    expect(wrapper).toMatchSnapshot();
  });

  it("snapshot of Writing For Products page", () => {
    const { wrapper } = setupShallow({
      source: fileWritingForProducts.data.file.childMarkdownRemark.html,
    });
    expect(wrapper).toMatchSnapshot();
  });

  it("snapshot of Accessibility page", () => {
    const { wrapper } = setupShallow({
      source: fileAccessibility.data.file.childMarkdownRemark.html,
    });
    expect(wrapper).toMatchSnapshot();
  });

  it("snapshot of Transition Group page", () => {
    const { wrapper } = setupShallow({
      source: fileTransitionGroup.data.file.childMarkdownRemark.html,
    });
    expect(wrapper).toMatchSnapshot();
  });
});
