import { withPrefix } from "gatsby";
import * as React from "react";
import {
  AlignItems,
  Background,
  BorderRadius,
  Column,
  Columns,
  CoreImage,
  Display,
  FlexDirection,
  Grid,
  InjectLayout,
  InjectStyledLayout,
  JustifyContent,
  Layout,
  Padding,
  Position,
  StyledLayout,
  ZIndex,
} from "twitch-core-ui";
import { isVideo } from "../../../../utils/asset-helpers";
import { Caption } from "../../../caption";

interface Props {
  data: {
    mediaSrc: string;
    caption?: string;
    cols?: Columns;
  };
}

export const BlockMedia = (props: Props) => {
  let mediaElement: JSX.Element | null;
  let mediaSrc = withPrefix(props.data.mediaSrc);

  if (isVideo(mediaSrc)) {
    mediaElement = (
      <InjectLayout display={Display.Block} fullWidth>
        <video src={mediaSrc} controls>
          Sorry, your browser doesn't support embedded videos.
        </video>
      </InjectLayout>
    );
  } else {
    mediaElement = <CoreImage alt="" src={mediaSrc} />;
  }

  const wrapperPadding: Padding = props.data.caption ? { y: 3, x: 3 } : 3;

  return (
    <figure>
      <StyledLayout background={Background.Alt}>
        <Grid justifyContent={JustifyContent.Center}>
          <Column cols={{ default: 12, md: props.data.cols }}>
            <StyledLayout
              display={Display.InlineFlex}
              fullWidth
              justifyContent={JustifyContent.Center}
              alignItems={AlignItems.Center}
              flexDirection={FlexDirection.Column}
              borderRadius={BorderRadius.Medium}
              padding={0}
              breakpointMedium={{
                padding: wrapperPadding,
              }}
            >
              <InjectStyledLayout
                position={Position.Relative}
                zIndex={ZIndex.Above}
              >
                {mediaElement}
              </InjectStyledLayout>
            </StyledLayout>
          </Column>
        </Grid>
      </StyledLayout>
      {props.data.caption && (
        <Layout position={Position.Relative} zIndex={ZIndex.Default} fullWidth>
          <Caption label={props.data.caption} />
        </Layout>
      )}
    </figure>
  );
};
