import * as React from "react";
import {
  AlignItems,
  Background,
  Color,
  Display,
  JustifyContent,
  Position,
  StyledLayout,
} from "twitch-core-ui";
import "./styles.scss";

interface Props {
  children?: React.ReactNode;
}

export const Overlay = (props: Props) => {
  return (
    <StyledLayout
      className="overlay"
      background={Background.Overlay}
      color={Color.Base}
      position={Position.Fixed}
      attachTop
      attachLeft
      fullWidth
      fullHeight
      padding={3}
      display={Display.Flex}
      justifyContent={JustifyContent.Center}
      alignItems={AlignItems.Center}
    >
      {props.children}
    </StyledLayout>
  );
};
