import * as React from "react";
import {
  AlignItems,
  Column,
  Display,
  Grid,
  Layout,
  TextType,
  Title,
  TitleSize,
} from "twitch-core-ui";
import { File } from "../../graphql-types";
import { getDisplayTitle } from "../../utils/display-titles";
import { parseMarkdownFromString } from "../../utils/parse-markdown-from-string";
import { AuthenticateCallout } from "../authenticate-callout";
import { BaseSize, Markdown } from "../markdown";

interface Props {
  page: File;
}

export class PageHeading extends React.Component<Props, {}> {
  public render() {
    let { childMarkdownRemark } = this.props.page;
    let description = "";
    if (
      childMarkdownRemark &&
      childMarkdownRemark.frontmatter &&
      childMarkdownRemark.frontmatter.description
    ) {
      description = childMarkdownRemark.frontmatter.description;
    }

    return (
      <div>
        <Layout
          display={Display.Flex}
          alignItems={AlignItems.Center}
          padding={{ bottom: 2 }}
        >
          <Layout
            flexGrow={1}
            display={Display.Flex}
            alignItems={AlignItems.Center}
          >
            <Title size={TitleSize.ExtraLarge} type={TextType.H1}>
              {getDisplayTitle(this.props.page)}
            </Title>
          </Layout>
        </Layout>
        <Grid>
          {description && (
            <Column cols={{ default: 12, lg: 8 }}>
              <Markdown
                size={BaseSize.Larger}
                source={parseMarkdownFromString(description)}
              />
            </Column>
          )}
          <AuthenticateCallout />
        </Grid>
      </div>
    );
  }
}
