import { Input, InputType, Toggle } from "twitch-core-ui";
import { setupShallowTest } from "../../../../tests/helpers";
import { PropField, Props } from "./component";

const mockFn = jest.fn();

function getProps(): Props {
  return {
    currentValue: "",
    originalValue: "",
    name: "show",
    availableValues: null,
    flags: {
      isExported: null,
      isOptional: false,
    },
    onValueChange: mockFn,
    comment: null,
    breakpointCompatible: false,
    sourceSrc: "",
    type: "boolean",
  };
}

const setupShallow = setupShallowTest(PropField, getProps);

describe("playground prop field", () => {
  it("renders a Toggle for boolean types", () => {
    const { wrapper } = setupShallow({ type: "boolean" });
    expect(wrapper.find(Toggle).length).toBe(1);
  });

  it("renders a Input for string types", () => {
    const { wrapper } = setupShallow({ type: "string" });
    const input = wrapper.find(Input);
    expect(input.length).toBe(1);
    expect(input.first().props().type).toBe(InputType.Text);
  });

  it("renders a number Input for number types", () => {
    const { wrapper } = setupShallow({ type: "number" });
    const input = wrapper.find(Input);
    expect(input.length).toBe(1);
    expect(input.first().props().type).toBe(InputType.Number);
  });

  it("calls onValueChange when Toggle is clicked", () => {
    const { wrapper } = setupShallow({ name: "testPropName", type: "boolean" });

    wrapper.find(Toggle).simulate("change", {
      currentTarget: { type: "checkbox", checked: true },
    });

    expect(mockFn).toHaveBeenCalledWith("testPropName", true);
  });
});
