import { availableValues_2 as AvailableValues } from "../../../graphql-types";
import { buttonData } from "../../../tests/data/TypeDoc_Button";
import { svgData } from "../../../tests/data/TypeDoc_SVG";
import {
  formatAvailableValue,
  propsToRenderString,
  setupDefaultPropValues,
} from "./property-helpers";

describe("setupDefaultPropValues", () => {
  it("matches the snapshot test", () => {
    const result = setupDefaultPropValues(buttonData.properties || []);
    expect(result).toMatchSnapshot();
  });

  it("handles default values for enums correctly", () => {
    const result = setupDefaultPropValues(svgData.properties || []);
    expect(result).toContainEqual(
      expect.objectContaining({
        name: "asset",
        originalValue: "SVGAsset.Account",
        currentValue: "SVGAsset.Account",
      }),
    );
  });
});

describe("propsToRenderString", () => {
  it("human readable mode matches the snapshot test", () => {
    const props = setupDefaultPropValues(buttonData.properties || []);

    // Set some props
    let sizeProp = props.find(prop => prop.name === "size");
    if (sizeProp) {
      sizeProp.currentValue = "ButtonSize.Large";
    }

    // Set another prop
    let ariaProp = props.find(prop => prop.name === "ariaLabel");
    if (ariaProp) {
      ariaProp.currentValue = "Hello I am a button";
    }

    // Set another prop
    let blurProp = props.find(prop => prop.name === "blurAfterClick");
    if (blurProp) {
      blurProp.currentValue = true;
    }

    // Set a number prop
    let tabIndexProp = props.find(prop => prop.name === "tabIndex");
    if (tabIndexProp) {
      tabIndexProp.currentValue = "1";
    }

    const result = propsToRenderString("Button", props, true);
    expect(result).toMatchSnapshot();
  });

  it("regular mode matches the snapshot test", () => {
    const props = setupDefaultPropValues(buttonData.properties || []);

    // Set some props
    let sizeProp = props.find(prop => prop.name === "size");
    if (sizeProp) {
      sizeProp.currentValue = "ButtonSize.Large";
    }

    // Set another prop
    let ariaProp = props.find(prop => prop.name === "ariaLabel");
    if (ariaProp) {
      ariaProp.currentValue = "Hello I am a button";
    }

    // Set another prop
    let blurProp = props.find(prop => prop.name === "blurAfterClick");
    if (blurProp) {
      blurProp.currentValue = true;
    }

    // Set a number prop
    let tabIndexProp = props.find(prop => prop.name === "tabIndex");
    if (tabIndexProp) {
      tabIndexProp.currentValue = "1";
    }

    const result = propsToRenderString("Button", props, false);
    expect(result).toMatchSnapshot();
  });
});

it("renders the correct value for enum types", () => {
  const availableValues: AvailableValues = {
    name: "TestValue",
    properties: null,
    sourceSrc: "path/to/source/on/github",
    type: "Enumeration",
    values: [],
  };

  expect(formatAvailableValue("EnumMember", availableValues)).toBe(
    "TestValue.EnumMember",
  );

  expect(formatAvailableValue("TestValue.EnumMember", availableValues)).toBe(
    "TestValue.EnumMember",
  );
});

describe("formatAvailableValue", () => {
  it("renders the correct value for non-enum types", () => {
    const testValues = ["0", "1", "2"];
    const availableValues: AvailableValues = {
      name: "TestValue",
      properties: null,
      sourceSrc: "path/to/source/on/github",
      type: "Type alias",
      values: testValues,
    };

    const result = formatAvailableValue(testValues[1], availableValues);
    expect(result).toBe("1");
  });
});
