import * as React from "react";
import {
  Background,
  InjectLayout,
  Overflow,
  Position,
  StyledLayout,
  SVG,
  SVGAsset,
  SVGType,
  Transition,
  TransitionDuration,
  TransitionType,
} from "twitch-core-ui";

export interface Props {
  type: TransitionType;
}

interface State {
  show: boolean;
}

export class TransitionTypePreview extends React.PureComponent<Props, State> {
  public state = {
    show: false,
  };

  public render() {
    return (
      <div onMouseEnter={this.onMouseIn} onMouseLeave={this.onMouseOut}>
        <StyledLayout
          background={Background.Alt}
          overflow={Overflow.Hidden}
          padding={2}
          border
          position={Position.Relative}
        >
          <SVG asset={SVGAsset.MiniPlayerPlay} type={SVGType.Alt2} />
          <InjectLayout
            position={Position.Absolute}
            attachTop
            attachLeft
            attachBottom
            attachRight
          >
            <Transition
              show={this.state.show}
              type={this.props.type}
              duration={TransitionDuration.Long}
            >
              <StyledLayout
                background={Background.AccentAlt}
                position={Position.Absolute}
                attachTop
                attachLeft
                attachBottom
                attachRight
              />
            </Transition>
          </InjectLayout>
        </StyledLayout>
      </div>
    );
  }

  private onMouseIn = () => {
    this.setState({
      show: true,
    });
  };

  private onMouseOut = () => {
    this.setState({
      show: false,
    });
  };
}
