import * as React from "react";
import Moment from "../../../node_modules/react-moment";
import {
  Background,
  Color,
  Display,
  JustifyContent,
  Layout,
  StyledLayout,
  TextType,
  Title,
  TitleSize,
} from "../../../node_modules/twitch-core-ui";
import { GithubVersionRelease } from "../../graphql-types";
import { parseMarkdownFromString } from "../../utils/parse-markdown-from-string";
import { Markdown } from "../markdown";
import "./styles.scss";

interface Props {
  node: GithubVersionRelease;
}

export const ReleaseNotesTile: React.SFC<Props> = (props: Props) => {
  const { data } = props.node;
  if (!data) {
    return null;
  }

  return (
    <StyledLayout className="release-notes-tile" border elevation={3}>
      <StyledLayout
        display={Display.Flex}
        justifyContent={JustifyContent.Between}
        background={Background.AccentAlt2}
        color={Color.Overlay}
        padding={2}
      >
        <Layout>
          <Title size={TitleSize.Large} type={TextType.H2}>
            {data.tagName}
          </Title>
          <Moment format="MMMM D, YYYY">{data.publishedAt || ""}</Moment>
        </Layout>
      </StyledLayout>

      <Layout padding={2}>
        {data.body && (
          <Markdown
            source={parseMarkdownFromString(data.body)}
            hideCopyCodeButton
          />
        )}
      </Layout>
    </StyledLayout>
  );
};
