import * as React from "react";
import { SearchInput } from "twitch-core-ui";
import "./styles.scss";

interface Props {
  term: string;
  onChange?: React.KeyboardEventHandler;
  onFocus?: React.KeyboardEventHandler;
  onBlur?: React.KeyboardEventHandler;
  refDelegate?: (e: HTMLInputElement) => void;
}

interface State {
  showKeyBindings: boolean;
  term: string;
}

export class SiteSearchInput extends React.Component<Props, State> {
  constructor(props: Props) {
    super(props);

    this.state = {
      term: props.term,
      showKeyBindings: false,
    };
  }

  public componentWillReceiveProps(nextProps: Props) {
    this.setState({
      term: nextProps.term,
      showKeyBindings: nextProps.term.length > 0 ? true : false,
    });
  }

  public render() {
    return (
      <>
        <SearchInput
          refDelegate={this.props.refDelegate}
          onFocus={this.onFocus}
          onBlur={this.onBlur}
          onChange={this.onChange}
          onKeyDown={this.onKeyDown}
          placeholder="Search"
          value={this.props.term}
        />
      </>
    );
  }

  private onFocus = (e: React.KeyboardEvent<HTMLInputElement>) => {
    if (this.props.onFocus) {
      return this.props.onFocus(e);
    }
  };

  private onBlur = (e: React.KeyboardEvent<HTMLInputElement>) => {
    if (this.props.onBlur) {
      return this.props.onBlur(e);
    }
  };

  private onKeyDown = (e: React.KeyboardEvent<HTMLInputElement>) => {
    // Prevent the cursor from moving to the front of the search input when
    // navigating through search inputs using the keyboard arrows.
    if (e.key === "ArrowUp") {
      e.preventDefault();
      return;
    }
  };

  private onChange = (e: React.KeyboardEvent<HTMLInputElement>) => {
    if (this.props.onChange) {
      this.props.onChange(e);
    }
  };
}
